package com.amotassic.dabaosword.item.skillcard;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.SkillExecutor;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.skills.Qun;
import com.amotassic.dabaosword.item.skillcard.skills.Shu;
import com.amotassic.dabaosword.item.skillcard.skills.Wei;
import com.amotassic.dabaosword.item.skillcard.skills.Wu;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_7923;

@SuppressWarnings("unused")
public class SkillCards {
    public static final Map<class_1792, List<SkillExecutor>> SKILL_MAP = new HashMap<>();
    public static final List<SkillItem> SKILLS = new ArrayList<>();
    //魏
    public static final SkillItem
    CHENGXIANG = register("chengxiang", Wei.Chengxiang::new),
    DAOSHU = register("daoshu", Wei.Daoshu::new),
    DUANLIANG = register("duanliang", Wei.Duanliang::new),
    FANGZHU = register("fangzhu", Wei.Fangzhu::new),
    XINGSHANG = register("xingshang", Wei.Xingshang::new),
    GANGLIE = register("ganglie", Wei.Ganglie::new),
    GONGAO = register("gongao", Wei.Gongao::new),
    JIANXIONG = register("jianxiong", Wei.Jianxiong::new),
    JUEQING = register("jueqing", Wei.Jueqing::new),
    LUOSHEN = register("luoshen", Wei.Luoshen::new),
    QINGGUO = register("qingguo", Wei.Qingguo::new),
    LUOYI = register("luoyi", Wei.Luoyi::new),
    QICE = register("qice", Wei.Qice::new),
    QUANJI = register("quanji", Wei.Quanji::new),
    SHANZHUAN = register("shanzhuan", Wei.Shanzhuan::new),
    SHENSU = register("shensu", Wei.Shensu::new),
    YIJI = register("yiji", Wei.Yiji::new),
    //蜀
    BENXI = register("benxi", Shu.Benxi::new),
    HUILEI = register("huilei", Shu.Huilei::new),
    HUOJI = register("huoji", Shu.Huoji::new),
    KANPO = register("kanpo", Shu.Kanpo::new),
    JIZHI = register("jizhi", Shu.Jizhi::new),
    KUANGGU = register("kuanggu", Shu.Kuanggu::new),
    LIEGONG = register("liegong", Shu.Liegong::new),
    LONGDAN = register("longdan", Shu.Longdan::new),
    PAOXIAO = register("paoxiao", Shu.Paoxiao::new),
    RENDE = register("rende", Shu.Rende::new),
    TIEJI = register("tieji", Shu.Tieji::new),
    WUSHENG = register("wusheng", Shu.Wusheng::new),
    //吴
    BUQU = register("buqu", Wu.Buqu::new),
    FANJIAN = register("fanjian", Wu.Fanjian::new),
    FENYIN = register("fenyin", Wu.Fenyin::new),
    GONGXIN = register("gongxin", Wu.Gongxin::new),
    GUOSE = register("guose", Wu.Guose::new),
    LIANYING = register("lianying", Wu.Lianying::new),
    LIULI = register("liuli", Wu.Liuli::new),
    KUROU = register("kurou", Wu.Kurou::new),
    POJUN = register("pojun", Wu.Pojun::new),
    QIXI = register("qixi", Wu.Qixi::new),
    SHIXIN = register("shixin", Wu.Shixin::new),
    XIAOJI = register("xiaoji", Wu.Xiaoji::new),
    YINGZI = register("yingzi", Wu.Yingzi::new),
    ZHIHENG = register("zhiheng", Wu.Zhiheng::new),
    ZHIJIAN = register("zhijian", Wu.Zhijian::new),
    //群
    DUANCHANG = register("duanchang", Qun.Duanchang::new),
    JIJIU = register("jijiu", Qun.Jijiu::new),
    JIUCHI = register("jiuchi", Qun.Jiuchi::new),
    JIZHAN = register("jizhan", Qun.Jizhan::new),
    LEIJI = register("leiji", Qun.Leiji::new),
    LUANJI = register("luanji", Qun.Luanji::new),
    TAOLUAN = register("taoluan", Qun.Taoluan::new),
    WEIMU = register("weimu", Qun.Weimu::new),
    MASHU = register("mashu", Qun.Mashu::new),

    FEIYING = register("feiying", Qun.Feiying::new);

    public static <T extends SkillItem> T register(String name, Function<class_1792.class_1793, T> factory) {
        T skill = ModItems.register(name, factory, 1);
        SKILLS.add(skill);
        return skill;
    }

    private static void addSkillEffect(class_1792 skill) {
        List<SkillExecutor> effectDatas = new ArrayList<>();
        Class<?> skillClass = skill.getClass();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Method method : skillClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(SkillInfo.class)) {
                SkillInfo info = method.getAnnotation(SkillInfo.class);
                MethodHandle handle;
                try {
                    handle = lookup.unreflect(method).bindTo(skill);
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                SkillExecutor effectData = new SkillExecutor(info.trigger(), Relation.getPredicate(info.relation()), handle);
                effectDatas.add(effectData);
            }
        }
        SKILL_MAP.put(skill, effectDatas);
    }

    public static void register() {
        class_7923.field_41178.method_10220().filter(i -> i instanceof ISkill).forEach(SkillCards::addSkillEffect);
    }

}
