package com.amotassic.dabaosword.item.skillcard;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.card.CardItem;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

import static com.amotassic.dabaosword.util.ModTools.*;

public class SkillItem extends class_1792 implements ISkill {
    public SkillItem(class_1793 settings) {super(settings);
        TrinketsApi.registerTrinket(this, this);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && equipped(stack)) setEquipped(stack, false);
    }

    public void method_7851(class_1799 s, class_9635 c, List<class_2561> t, class_1836 ty) {addTip(s(s), t);}
    public void addTip(Skill skill, List<class_2561> tooltip) {}
    public class_5250 getTip(class_124... format) {return getTip("", format);}
    public class_5250 getTip(String suffix, class_124... format) {
        return class_2561.method_43471(method_7876() + ".tooltip" + suffix).method_27695(format);
    }

    public final void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        ISkill.super.tick(stack, slot, entity);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_37908().field_9236 && user.method_5752().contains("change_skill") && hand == class_1268.field_5810 && user.method_5715()) {
            class_1799 stack = user.method_6079();
            if (stack.method_7909() instanceof SkillItem) {
                stack.method_7939(0);
                changeSkill(user);
                user.method_5752().remove("change_skill");
                return class_1269.field_52422;
            }
        }
        class_1799 stack = user.method_5998(hand);
        if (TrinketItem.equipItem(user, stack)) {
            return class_1269.field_52422;
        }
        return class_1269.field_5811;
    }

    public static void changeSkill(class_1657 player) {
        class_1799 stack = customLoot(player, "draw_skill");
        if (!stack.method_7960()) voice(player, "giftbox",3);
        give(player, stack);
    }

    /**转化卡牌技能通用方法*/
    public static void viewAs(class_1309 entity, Skill skill, int CD, Predicate<class_1799> p, CardItem result) {
        if (entity.method_37908().field_9236) return;
        if (skill.getCD() > 0) return;
        class_1799 off = entity.method_6079(); var copy = off.method_7972();
        if (off.method_7960()) return;
        if (p.test(off)) {
            skill.setCD(CD);
            off.method_7934(1);
            give(entity, c(copy, result).toStack());
            voice(entity, skill.stack);
        }
    }

    public class_2561 activeSkillText(class_1657 user, Skill skill) {
        return class_2561.method_43471("active_skill.select_target").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/dabaosword " + user.method_5477().getString() + " " + class_7923.field_41178.method_10221(skill.stack.method_7909()) + " ")));
    }
}
