package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.skill.*;
import com.amotassic.dabaosword.command.DabaoSwordCommand;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_8111;

import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.*;

public class Qun {

    public static class Duanchang extends SkillItem {
        public Duanchang(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip());}

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.SELF)
        public int chicai(class_1309 user, class_1309 target, Skill skill, ExData data) {
            class_1297 killer = null; class_1297 attacker = data.source.method_5529();
            if (attacker instanceof class_1657 player) killer = player;
            else if (user.method_6124() != null) killer = user.method_6124();
            if (killer instanceof class_1657 pl) {
                voice(user, this);
                killer.method_5780("duanchang");
                pl.method_7353(class_2561.method_43471("duanchang.tip").method_27695(field_1061, field_1067), false);
            }
            return 0;
        }
    }

    public static class Jijiu extends SkillItem {
        public Jijiu(class_1793 settings) {super(settings);}

        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 10s"));
            tooltip.add(getTip());
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            viewAs(entity, skill, 10, isRedCard, ModItems.PEACH);
        }
    }

    public static class Jiuchi extends SkillItem {
        public Jiuchi(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 10s"));
            tooltip.add(getTip());
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            viewAs(entity, skill, 10, isSpadeCard, ModItems.JIU);
        }
    }

    public static class Jizhan extends SkillItem implements DabaoSwordCommand.CSkill {
        public Jizhan(class_1793 settings) {super(settings);}
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2"));
        }

        private final class_5250 JIZHAN_TEXT = class_2561.method_43469("jizhan.text",
                class_2561.method_43471("rank.higher").method_27692(field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword @s dabaosword:jizhan @s 1"))),
                class_2561.method_43471("rank.lower").method_27692(field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword @s dabaosword:jizhan @s -1"))));

        @Override
        public int onDrawPhase(class_1657 player, Skill skill) {
            voice(player, this);
            class_1799 last = newCard();
            give(player, last); //先让玩家摸一张牌，保存到lastCard
            player.method_37908().method_18456().forEach(p -> p.method_7353(class_2561.method_43469("jizhan.draw", player.method_5476(), skill.toHoverableText(), last.method_7954(), c(last).rank.rank), false));
            var tag = skill.getNbt();
            tag.method_10569("lastCardRank", c(last).rank.ordinal());
            skill.setNbt(tag);
            player.method_7353(JIZHAN_TEXT, false);
            return -114;
        }

        @Override
        public void triggerSkill(class_1309 entity, Skill skill, class_1309 target, int value) {
            int last = skill.getNbt().method_10550("lastCardRank");
            if (last == -1 || !(entity instanceof class_1657 player)) return;
            class_1799 next = newCard();
            give(player, next); //又让玩家摸一张牌后，比较两张牌的点数，如果玩家选对了，就把新的牌保存到lastCard，否则关闭菜单
            player.method_37908().method_18456().forEach(p -> p.method_7353(class_2561.method_43469("jizhan.draw", player.method_5476(), skill.toHoverableText(), next.method_7954(), c(next).rank.rank), false));
            //下一张牌与上一张牌点数比较，有3种情况：更大返回1，更小返回-1，相等返回0
            int cmp = Integer.compare(c(next).rank.ordinal(), last);
            //玩家选择只有两张情况：选更大返回1，选更小返回-1
            var tag = skill.getNbt();
            if (cmp == value) {
                tag.method_10569("lastCardRank", c(next).rank.ordinal());
                player.method_7353(JIZHAN_TEXT, false);
            } else tag.method_10569("lastCardRank", -1);
            skill.setNbt(tag);
        }
    }

    public static class Leiji extends SkillItem {
        public Leiji(class_1793 settings) {super(settings);}

        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip());}

        @SkillInfo(trigger = Trigger.LOSE_CARD_USE, relation = Relation.SELF)
        public int useShan(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var card = data.getFirst();
            if (card.isOf(ModItems.SHAN)) {
                voice(user, this);
                user.method_6092(new class_1293(ModItems.COOLDOWN2, 10,3,false,false,false));
            }
            return 0;
        }

        @SkillInfo(trigger = Trigger.CANCEL_DAMAGE_HIGH, relation = Relation.SELF)
        public int fanglei(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var source = data.source;
            if (source.method_49708(class_8111.field_42336) && source.method_5529() == null) return 1;
            return 0;
        }
    }

    public static class Luanji extends SkillItem {
        public Luanji(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 15s" : "CD: 15s   left: "+ cd +"s"));
            tooltip.add(getTip());
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public void addScreenTip(Skill skill, List<class_2561> tips) {
            addPresetTips(skill, tips, 0, 1, 2, 4, 5);
            super.addScreenTip(skill, tips);
        }

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            if (skill.getCD() > 0) return false;
            if (ofSuit(user, isDiamondCard) || ofSuit(user, isHeartCard) || ofSuit(user, isClubCard) || ofSuit(user, isSpadeCard)) {
                skill.setMaxSelect(2);
                openInv(user, user, user, class_2561.method_43471("item.dabaosword.luanji.suit"), skill.stack, false, false, 2);
                return true;
            }
            return false;
        }

        boolean ofSuit(class_1657 user, Predicate<class_1799> p) {return countCard(user, p) > 1;}

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
            int count = handler.getSelectedCount();
            List<class_1799> selects = handler.getSelected(); class_1799 choose = handler.getStack(slot);
            boolean bl = count == 0 || c(selects.getFirst()).suit == c(choose).suit;
            if (bl && action == class_1713.field_7790) { //左键点击+1，右键点击-1
                if (button == 0) handler.addClick(slot);
                if (button == 1) handler.dropClick(slot);
            }
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
            if (handler.getSelectedCount() == 2) {
                voice(player, this);
                skill.setCD(15);
                Card card = new Card(ModItems.WANJIAN, c(handler.getSelected().getFirst()).suit, Rank.Ace);
                handler.toExData().clearCards(player);
                give(player, card.toStack());
            }
        }
    }

    public static class Taoluan extends SkillItem {
        public Taoluan(class_1793 settings) {super(settings);}

        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip());}

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            List<CardItem> items = ModItems.CARDS.stream().filter(i -> i.getType() != 2).toList();
            String[] used = skill.getNbt().method_10558("used").split(";");
            if (used.length == items.size()) {
                user.method_7353(class_2561.method_43471("item.dabaosword.taoluan.fail").method_27692(field_1061), true);
                return false;
            }
            if (user.method_6032() + 5 * countCard(user, canSaveDying) > 4.99) {

                List<class_1799> stacks = items.stream().filter(i -> !Arrays.stream(used).toList().contains(class_7923.field_41178.method_10221(i).method_12832())).map(class_1799::new).toList();

                openMenu(user, user, skill.stack, stacks, class_2561.method_43471("item.dabaosword.taoluan.screen"));
                return true;
            } else user.method_7353(class_2561.method_43471("item.dabaosword.taoluan.tip").method_27692(field_1061), true);
            return false;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
            var selected = handler.getStack(slot);
            give(player, selected);
            if (!player.method_7337()) {
                var nbt = skill.getNbt();
                String used = nbt.method_10558("used"); String item = class_7923.field_41178.method_10221(selected.method_7909()).method_12832();
                used = used.isEmpty() ? item : used + ";" + item;
                nbt.method_10582("used", used); skill.setNbt(nbt);
                player.field_6008 = 0;
                player.method_64397(world(player), player.method_48923().method_51847(), 4.99f);
            }
            voice(player, this);
            closeGUI(player);
        }

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.SELF)
        public int refresh(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var nbt = skill.getNbt();
            nbt.method_10551("used"); skill.setNbt(nbt);
            return 0;
        }
    }

    public static class Weimu extends SkillItem {
        public Weimu(class_1793 settings) {super(settings);}

        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip());}

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.DROP_TARGET, relation = Relation.ANY)
        public int weimu(class_1309 user, class_1309 target, Skill skill, ExData data) {
            //这里的user才是卡牌的目标，即技能的发动者
            var card = data.getFirst();
            if (data.targets.contains(user) && isBlackCard.and(isArmoury).test(card.toStack())) {
                data.removeTarget(user);
                voice(user, this);
            }
            return 0;
        }
    }

    public static class Mashu extends SkillItem {
        public Mashu(class_1793 settings) {super(settings);}

        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43471("item.dabaosword.chitu.tooltip"));
        }

        @Override public boolean lockOn() {return true;}

        public int getExtraReach(class_1309 entity, Skill skill) {return 1;}
    }

    public static class Feiying extends SkillItem {
        public Feiying(class_1793 settings) {super(settings);}

        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43471("item.dabaosword.dilu.tooltip"));
        }

        @Override public boolean lockOn() {return true;}

        public int getDefend(class_1309 entity, Skill skill) {return 1;}
    }
}
