package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.*;
import com.amotassic.dabaosword.event.PlayerEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.field_1061;

public class Shu {

    public static class Benxi extends SkillItem {
        public Benxi(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int benxi = skill.getTag();
            tooltip.add(class_2561.method_30163("奔袭：" + benxi));
            tooltip.add(getTip("1", field_1061));
            tooltip.add(getTip("2", field_1061));
        }

        @Override public boolean lockOn() {return true;}

        @Override
        public int getExtraReach(class_1309 entity, Skill skill) {return skill.getTag();}

        @SkillInfo(trigger = Trigger.LOSE_CARD_USE, relation = Relation.SELF)
        public int useCard(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var benxi = skill.getTag();
            if (benxi < 5) {skill.setTag(benxi + 1); voice(user, this);}
            return 0;
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.DIRECT_ATTACKER)
        public int onHit(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var benxi = skill.getTag();
            if (!user.method_5752().contains("benxi") && benxi > 1) {
                user.method_5780("benxi");
                skill.setTag(benxi - 2);
                draw(user);
                voice(user, this);
            }
            return 0;
        }
    }

    public static class Huilei extends SkillItem {
        public Huilei(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1061));}

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.SELF)
        public int wu555(class_1309 user, class_1309 target, Skill skill, ExData data) {
            class_1297 killer = null; class_1297 attacker = data.source.method_5529();
            if (attacker instanceof class_1309 entity) killer = entity;
            else if (user.method_6124() != null) killer = user.method_6124();
            if (killer instanceof class_1657 pl) {
                voice(user, this);
                CardEvents.cardDiscard(pl, PlayerEvents.cardsToDrop(pl));
                for (var stack : pl.method_31548().field_7547) {
                    if (stack.method_7960()) continue;
                    var item = pl.method_7328(stack.method_7972(), true);
                    if (item != null) {
                        item.method_5684(true);
                        item.method_48349(pl.method_5667());
                        item.method_6982(400);
                    }
                    stack.method_7939(0);
                }
            }
            return 0;
        }
    }

    public static class Huoji extends SkillItem {
        public Huoji(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 15s" : "CD: 15s   left: "+ cd +"s"));
            tooltip.add(getTip(field_1061));
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            viewAs(entity, skill, 15, isRedCard, ModItems.FIRE_ATTACK);
        }
    }

    public static class Jizhi extends SkillItem {
        public Jizhi(class_1793 settings) {super(settings);}
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1061));}

        @SkillInfo(trigger = Trigger.LOSE_CARD_USE, relation = Relation.SELF)
        public int useCard(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var card = data.getFirst().toStack();
            if (isArmoury.test(card)) {draw(user); voice(user, this);}
            return 0;
        }
    }

    public static class Kanpo extends SkillItem {
        public Kanpo(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 10s" : "CD: 10s   left: "+ cd +"s"));
            tooltip.add(getTip(field_1061));
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            viewAs(entity, skill, 10, isBlackCard, ModItems.WUXIE);
        }
    }

    public static class Kuanggu extends SkillItem {
        public Kuanggu(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 8s"));
            tooltip.add(getTip(field_1061));
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.DIRECT_ATTACKER)
        public int onAttack(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (user.method_6059(ModItems.COOLDOWN)) return 0;
            if (user.method_6063() - user.method_6032() >= 5) user.method_6025(5);
            else draw(user);
            voice(user, this);
            user.method_6092(new class_1293(ModItems.COOLDOWN, 20 * 8,0,false,false,true));
            return 0;
        }
    }

    public static class Liegong extends SkillItem {
        public Liegong(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1061));
            tooltip.add(getTip("2", field_1061));
        }

        @Override
        public int getExtraReach(class_1309 entity, Skill skill) {
            return entity.method_6059(ModItems.COOLDOWN) ? 0 : 13;
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            if (!player.method_6059(ModItems.COOLDOWN)) {
                //烈弓：命中后给目标一个短暂的冷却效果，防止其自动触发闪
                target.method_6092(new class_1293(ModItems.COOLDOWN2,2,0,false,false,false));
            }
        }

        @SkillInfo(trigger = Trigger.MODIFY_DAMAGE, relation = Relation.DIRECT_ATTACKER)
        public int addDamage(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var adds = data.adds;
            if (!user.method_6059(ModItems.COOLDOWN)) {
                float f = Math.max(13 - user.method_5739(target), 5);
                user.method_6092(new class_1293(ModItems.COOLDOWN, (int) (40 * f),0,false,false,true));
                voice(user, this);
                adds.add(f);
            }
            return 0;
        }
    }

    public static class Longdan extends SkillItem {
        public Longdan(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1061));
            tooltip.add(getTip("2", field_1061));
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            if (entity.method_37908() instanceof class_3218 world && entity instanceof class_1657 player) {
                class_1799 off = player.method_6079(); class_1799 copy = off.method_7972();
                if (world.method_8510() % 20 == 0 && isBasic.test(off)) {
                    off.method_7934(1);
                    give(player, getLongdanCard(copy).toStack());
                    voice(player, this);
                }
            }
        }

        private Card getLongdanCard(class_1799 stack) {
            if (stack.method_31574(ModItems.SHAN)) return c(stack, ModItems.SHA);
            if (stack.method_31574(ModItems.PEACH)) return c(stack, ModItems.JIU);
            if (stack.method_31574(ModItems.JIU)) return c(stack, ModItems.PEACH);
            return c(stack, ModItems.SHAN);
        }
    }

    public static class Paoxiao extends SkillItem {
        public Paoxiao(class_1793 settings) {super(settings);}

        @Override public boolean lockOn() {return true;}

        @Override
        public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
            var modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
            if (entity.method_5752().contains("duanchang")) return modifiers;
            modifiers.put(class_5134.field_23723, new class_1322(slotIdentifier, 1, class_1322.class_1323.field_6331));
            return modifiers;
        }

        @SkillInfo(trigger = Trigger.SELECT_TARGET, relation = Relation.NOT_SELF)
        public int yuyin(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (isSha.test(data.getFirst().toStack())) voice(user, this);
            return 0;
        }
    }

    public static class Rende extends SkillItem {
        public Rende(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 30s" : "CD: 30s   left: "+ cd +"s"));
            tooltip.add(getTip("1", field_1061));
            tooltip.add(getTip("2", field_1061));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public void addScreenTip(Skill skill, List<class_2561> tips) {
            addPresetTips(skill, tips, 0, 1, 2, 3, 4);
            super.addScreenTip(skill, tips);
        }

        @Override
        public boolean activeSkill(class_1657 user, Skill skill, class_1309 entity) {
            if (entity instanceof class_1657 target && countCards(user) > 0) {
                openInv(user, user, target, class_2561.method_43469("give_card.title", skill.toHoverableText()), skill.stack, false, false, 2);
                return true;
            } return false;
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
            int count = handler.getSelectedCount();
            if (count == 0) return;
            voice(player, this);
            class_2561 message = class_2561.method_43469("give_card.tip", player.method_5476(), skill.toHoverableText(), target.method_5476(), count);
            target.method_7353(message, false);
            player.method_7353(message, false);
            CardEvents.cardMove(player, handler.toExData(), target);
            int cd = skill.getCD();
            if (player.method_6032() < player.method_6063() && cd == 0 && new Random().nextFloat() < 0.5 * count) {
                player.method_6025(5); voice(player, "peach");
                player.method_7353(class_2561.method_43471("recover.tip").method_27692(class_124.field_1060), true);
                skill.setCD(30);
            }
        }
    }

    public static class Tieji extends SkillItem {
        public Tieji(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1061));
            tooltip.add(getTip("2", field_1061));
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            if (hasItem(player, isSha)) {
                voice(player, this);
                target.method_6092(new class_1293(ModItems.TIEJI,200,0,false,true,true));
                if (new Random().nextFloat() < 0.75) target.method_6092(new class_1293(ModItems.COOLDOWN2,2,0,false,false,false));
            }
        }
    }

    public static class Wusheng extends SkillItem {
        public Wusheng(class_1793 settings) {super(settings);}
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 5s"));
            tooltip.add(getTip("1", field_1061));
            tooltip.add(getTip("2", field_1061));
        }

        @Override
        public int getExtraReach(class_1309 entity, Skill skill) {
            return isSha.test(entity.method_6047()) ? 13 : 0;
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            viewAs(entity, skill, 5, isRedCard, ModItems.SHA);
        }
    }
}
