package com.amotassic.dabaosword.item.tool;

import com.amotassic.dabaosword.ui.PileScreenHandler;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.ModTools;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

import static com.amotassic.dabaosword.util.ModTools.getCardPack;

public class CardPile extends TrinketItem {
    public CardPile(class_1793 properties) {super(properties);}

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add(class_2561.method_43471("item.dabaosword.card_pile.tooltip"));
        tooltip.add(class_2561.method_43473());
        tooltip.add(class_2561.method_43471("item.dabaosword.card_pile.tip1").method_27692(class_124.field_1067));
        tooltip.add(class_2561.method_43469("item.dabaosword.card_pile.tip2", class_2561.method_43472("key.dabaosword.select_card")).method_27692(class_124.field_1067));
        tooltip.add(class_2561.method_43469("item.dabaosword.card_pile.tip3", class_2561.method_43472("key.sprint"), class_2561.method_43472("key.dabaosword.select_card")).method_27692(class_124.field_1067));
        tooltip.add(class_2561.method_43469("item.dabaosword.card_pile.tip4", class_2561.method_43472("key.sprint"), class_2561.method_43472("key.sneak"), class_2561.method_43472("key.dabaosword.select_card")).method_27692(class_124.field_1067));
    }

    @Override
    public void tick(class_1799 pile, SlotReference slot, class_1309 entity) {
        if (entity.method_37908() instanceof class_3218 world && entity instanceof class_1657 player) {
            long time = world.method_8510();
            int skill = world.method_64395().method_8356(Gamerule.CHANGE_SKILL_INTERVAL) * 20;

            if (world.method_64395().method_8355(Gamerule.CARD_PILE_HUNGERLESS)) player.method_7344().method_7580(20);

            if (skill >= 0) {
                if (skill == 0) player.method_5780("change_skill");
                else if (time % skill == 0) { //每5分钟可以切换技能
                    player.method_5780("change_skill");
                    if (skill >= 600) {
                        player.method_7353(class_2561.method_43471("dabaosword.change_skill").method_27692(class_124.field_1067), false);
                        player.method_7353(class_2561.method_43471("dabaosword.change_skill2"), false);
                    }
                }
            }

            if (player.field_7512.getClass() != PileScreenHandler.class && time % 20 == 0) {
                var cards = getCardPack(player);
                for (int i = 9; i < 36; i++) {
                    class_1799 item = player.method_31548().field_7547.get(i);
                    if (ModTools.isCard(item) && cards.isNotFull()) {
                        cards.insertStack(item.method_7972());
                        item.method_7939(0);
                    }
                }
            }
        }
    }
}
