package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModConfig;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1665;
import net.minecraft.class_1674;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3852;
import net.minecraft.class_3855;
import net.minecraft.class_3966;
import net.minecraft.class_8111;
import net.minecraft.entity.projectile.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

import static com.amotassic.dabaosword.util.ModTools.*;

@Mixin(class_1297.class)
public abstract class EntityMixin {

    @Shadow public abstract boolean damage(class_3218 world, class_1282 source, float amount);

    @Inject(method = "onStruckByLightning", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/damage/DamageSource;F)Z"), cancellable = true)
    public void onStruckByLightning(class_3218 world, class_1538 lightning, CallbackInfo ci) {
        this.damage(world, damageSource(lightning, class_8111.field_42336), 5.0f);
        ci.cancel();
    }
}

@Mixin(class_1665.class)
abstract class ArrowEntiytMixin extends class_1676 {
    public ArrowEntiytMixin(class_1299<? extends class_1676> entityType, class_1937 world) {super(entityType, world);}

    @Shadow protected abstract boolean isInGround();

    @Inject(method = "tick", at = @At(value = "HEAD"))
    public void tick(CallbackInfo ci) {
        var tags = method_5752();
        if (this.isInGround()) {
            if (tags.contains("a") || tags.contains("cosmetic")) this.method_31472();
        }
    }

    @Inject(method = "onEntityHit", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;setFireTicks(I)V"))
    private void onHit(class_3966 entityHitResult, CallbackInfo ci) {
        if (method_5752().contains("a")) this.method_31472();
    }

    @Inject(method = "onEntityHit", at = @At(value = "HEAD"), cancellable = true)
    private void cosmetic(class_3966 entityHitResult, CallbackInfo ci) {
        if (method_5752().contains("cosmetic")) {
            this.method_31472(); ci.cancel();
        }
    }
}

@Mixin(class_1674.class)
abstract class FireballEntityMixin extends class_3855 {
    public FireballEntityMixin(class_1299<? extends class_3855> entityType, class_1937 world) {super(entityType, world);}

    @ModifyArgs(method = "onCollision", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZLnet/minecraft/world/World$ExplosionSourceType;)V"))
    public void onCollision(Args args) {
        if (method_37908() instanceof class_3218) {
            if (!ModConfig.FireAttackBreaksBlock && method_5752().contains("a")) {
                args.set(5, false);
                args.set(6, class_1937.class_7867.field_40888);
            }
        }
    }
}

@Mixin(class_1542.class)
abstract class ItemEntityMixin extends class_1297 {
    public ItemEntityMixin(class_1299<?> type, class_1937 world) {super(type, world);}

    @Shadow public abstract class_1799 getStack();

    @Shadow public abstract void setStack(class_1799 stack);

    @Shadow public abstract void resetPickupDelay();

    @Unique
    class_1542 thisItem = (class_1542) (Object) this;

    @Inject(method = "tick", at = @At("HEAD"))
    public void tick(CallbackInfo ci) {
        if (isCard(this.getStack())) this.resetPickupDelay();

        class_1799 stack = this.getStack();
        var entity = getClosestEntity(thisItem, class_1297.class, 0.2, e -> true);
        if (stack.method_31574(class_1802.field_8107) && stack.method_7947() == 64) {
            if (entity instanceof class_1542 item && item.method_6983().method_31574(class_1802.field_8102)) {
                item.method_6979(new class_1799(ModItems.ARROW_RAIN));
                this.method_31472();
            }
        }

        if (stack.method_31574(class_1802.field_8687) && stack.method_7947() == 64) {
            if (entity instanceof class_1646 villager && villager.method_7231().method_16924() == class_3852.field_17062) {
                this.setStack(new class_1799(ModItems.GIFTBOX, 1));
            }
        }
    }
}

@Mixin(class_1685.class)
abstract class TridentMixin extends class_1665 {
    protected TridentMixin(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "onEntityHit", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/projectile/TridentEntity;setVelocity(Lnet/minecraft/util/math/Vec3d;)V"))
    private void onHit(class_3966 entityHitResult, CallbackInfo ci) {
        if (method_5752().contains("a")) this.method_31472();
    }
}
