package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Arrays;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

import static com.amotassic.dabaosword.util.ModTools.*;

@Mixin(class_1308.class)
public abstract class MobEntityMixin extends class_1309 {
    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {super(entityType, world);}

    @Unique class_1308 mob = (class_1308) (Object) this;

    @Inject(method = "initEquipment", at = @At(value = "TAIL"))
    protected void initEquipment(class_5819 random, class_1266 localDifficulty, CallbackInfo ci) {
        if (!method_37908().field_9236 && new java.util.Random().nextFloat() < getChance()) initCards();
    }

    @Inject(method = "tryAttack", at = @At(value = "HEAD"))
    public void tryAttack(class_3218 world, class_1297 target, CallbackInfoReturnable<Boolean> cir) {
        if (isCard(method_6047()) && target instanceof class_1309 entity) tryUseCard(method_6047(), entity);
    }

    @Unique
    private void tryUseCard(class_1799 stack, class_1309 target) {
        if (!isBasic.test(stack) && !stack.method_31574(ModItems.WUXIE)) CardItem.onUse(mob, stack, target);
    }

    @Unique private float getChance() {
        class_1267 difficulty = method_37908().method_8407();
        if (difficulty == class_1267.field_5805) return 0.3f;
        if (difficulty == class_1267.field_5802) return 0.6f;
        if (difficulty == class_1267.field_5807) return 0.9f;
        return 0;
    }

    @Unique
    private void initCards() {
        if (method_6047().method_7960()) {
            method_6122(class_1268.field_5808, newCard(getMainCard()).method_46651((int) (3 * Math.random()) + 1));
        }
        if (method_6079().method_7960()) {
            method_6122(class_1268.field_5810, newCard(getOffCard()).method_46651((int) (2 * Math.random()) + 1));
        }
    }

    @Unique private class_1792 getMainCard() {
        if (new java.util.Random().nextFloat() > 0.33) {
            class_1792[] items = {ModItems.BINGLIANG_ITEM, ModItems.TOO_HAPPY_ITEM, ModItems.DISCARD, ModItems.FIRE_ATTACK, ModItems.JIEDAO, ModItems.WANJIAN, ModItems.TIESUO, ModItems.NANMAN, ModItems.JUEDOU, ModItems.SHANDIAN_ITEM};
            int index = new java.util.Random().nextInt(items.length);
            return Arrays.stream(items).toList().get(index);
        }
        return ModItems.SHA;
    }

    @Unique private class_1792 getOffCard() {
        if (new java.util.Random().nextFloat() < 0.5) return ModItems.SHAN;
        return ModItems.PEACH;
    }
}
