package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.api.event.EndEntityTick;
import com.amotassic.dabaosword.api.event.EntityHurtCallback;
import com.amotassic.dabaosword.api.event.PlayerDeathCallback;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {super(entityType, world);}

    @Inject(at = @At("TAIL"), method = "tick")
    public void tick(CallbackInfo ci) {
        if (this.method_5752().contains("px")) this.field_6273 = 1145;
        EndEntityTick.PLAYER_EVENT.invoker().endPlayerTick((class_1657) (Object) this);
    }

    @Inject(at = @At("TAIL"), method = "applyDamage")
    private void onEntityHurt(class_3218 world, class_1282 source, float amount, CallbackInfo ci) {
        EntityHurtCallback.EVENT.invoker().hurtEntity((class_1657) (Object) this, source, amount);
    }

    @ModifyVariable(method = "attack", at = @At(value = "STORE"), ordinal = 2)
    public boolean attack(boolean bl) {
        var entry = ModTools.getEntry(ModItems.CRIT, (class_1657) (Object) this);
        boolean crit = class_1890.method_8225(entry, method_6118(class_1304.field_6169)) > 0;
        return bl || crit;
    }
}

@Mixin(class_3222.class)
abstract class ServerPlayerEntityMixin extends PlayerEntityMixin {
    protected ServerPlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "onDeath", at = @At("HEAD"))
    public void onDeath(class_1282 damageSource, CallbackInfo callbackInfo) {
        PlayerDeathCallback.EVENT.invoker().onDeath(((class_3222) (Object) this), damageSource);
    }
}
