package com.amotassic.dabaosword.mixin.client;

import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

import static com.amotassic.dabaosword.util.ModTools.c;

@Mixin(class_332.class)
public abstract class DrawContextMixin {
    @Shadow @Final private class_4587 matrices;

    @Shadow @Final private class_310 client;

    @Shadow protected abstract void drawTexturedQuad(Function<class_2960, class_1921> renderLayers, class_2960 sprite, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2, int color);

    @Inject(method = "drawStackOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawItemBar(Lnet/minecraft/item/ItemStack;II)V"))
    public void drawItemInSlot(class_327 textRenderer, class_1799 stack, int x, int y, String countOverride, CallbackInfo ci) {
        var card = c(stack);
        var s = card.suit; var r = card.rank;
        if (s != Suit.None && r != Rank.None) {
            class_2960 suit = class_2960.method_60655("dabaosword", "textures/item/suit/" + getSuitName(s) + ".png");
            class_2960 rank = class_2960.method_60655("dabaosword", "textures/item/rank2/" + getRankName(s, r) + ".png");
            this.matrices.method_46416(0.0f, 0.0f, 200.0f);
            drawTexturedQuad(class_1921::method_62277, suit, x, x + 5, y, y + 5, 0, 1, 0, 1, -1);
            drawTexturedQuad(class_1921::method_62277, rank, x + 5, x + 11, y, y + 5, 0, 1, 0, 1, -1);
            this.matrices.method_46416(0.0f, 0.0f, -200.0f);
        }
    }

    @Unique private String getSuitName(Suit s) {
        return switch (s) {
            case Heart -> "heart";
            case Diamond -> "diamond";
            case Spade -> "spade_w";
            case Club -> "club_w";
            case None -> "";
        };
    }

    @Unique private String getRankName(Suit s, Rank r) {
        return switch (s) {
            case Heart, Diamond -> switch (r) {
                case Ace -> "ar";
                case Two -> "2r";
                case Three -> "3r";
                case Four -> "4r";
                case Five -> "5r";
                case Six -> "6r";
                case Seven -> "7r";
                case Eight -> "8r";
                case Nine -> "9r";
                case Ten -> "10r";
                case Jack -> "jr";
                case Queen -> "qr";
                case King -> "kr";
                case None -> "";
            };
            case Spade, Club -> switch (r) {
                case Ace -> "ab";
                case Two -> "2b";
                case Three -> "3b";
                case Four -> "4b";
                case Five -> "5b";
                case Six -> "6b";
                case Seven -> "7b";
                case Eight -> "8b";
                case Nine -> "9b";
                case Ten -> "10b";
                case Jack -> "jb";
                case Queen -> "qb";
                case King -> "kb";
                case None -> "";
            };
            case None -> "";
        };
    }
}
