package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.util.ModConfig;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class GameManager extends class_18 {
    private final Map<Integer, Game> games = new HashMap<>();
    private final class_3218 world;
    private int nextAvailableId;

    public static class_8645<GameManager> getPersistentStateType(class_3218 world) {
        return new class_8645<>(() -> new GameManager(world), (nbt, r) -> GameManager.fromNbt(world, nbt), null);
    }

    public GameManager(class_3218 world) {
        this.world = world;
        this.nextAvailableId = 1;
        method_80();
    }

    public int getGameCount() {return games.size();}

    @Nullable
    public Game createGame(class_3222 player, int type) {
        class_238 box = new class_238(player.method_24515()).method_1014(ModConfig.SearchRadius);
        List<class_1657> players = player.method_37908().method_8390(class_1657.class, box, p -> !p.method_7325() && !isPlayerInGame(p));
        if (players.size() < 2) {
            player.method_64398(class_2561.method_43470("Not enough players to start a game!").method_27692(class_124.field_1061));
            return null;
        }
        Set<UUID> playerUuids = new HashSet<>();
        for (class_1657 p : players) playerUuids.add(p.method_5667());
        Game game = new Game(nextId(), world, playerUuids, type);
        games.put(game.getGameId(), game);
        PVPGameEvents.onGameCreate(player, game, playerUuids);
        method_80();
        return game;
    }

    @Nullable
    public Game getGameByPlayer(class_1657 player) {
        for (Game game : games.values()) {
            if (game.isPlayerInThisGame(player)) return game;
        }
        return null;
    }

    /**判断玩家是否已经加入任意一场对战*/
    public boolean isPlayerInGame(class_1657 player) {return getGameByPlayer(player) != null;}

    public void tick() {
        Iterator<Game> iterator = this.games.values().iterator();
        while (iterator.hasNext()) {
            Game game = iterator.next();
            if (!game.isActive()) { //移除游戏
                iterator.remove();
                method_80();
                continue;
            }
            game.tick();
        }
        //if (world.getTime() % 200 == 0) System.out.println("GameManager tick: " + games.keySet());
        if (world.method_8510() % 200 == 0) method_80();
    }

    public static GameManager fromNbt(class_3218 world, class_2487 nbt) {
        GameManager gameManager = new GameManager(world);
        gameManager.nextAvailableId = nbt.method_10550("NextAvailableID");
        class_2499 nbtList = nbt.method_10554("Games", class_2520.field_33260);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            Game game = new Game(world, nbtCompound);
            gameManager.games.put(game.getGameId(), game);
        }
        return gameManager;
    }

    @Override
    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("NextAvailableID", this.nextAvailableId);
        class_2499 nbtList = new class_2499();
        for (Game game : games.values()) {
            class_2487 nbtCompound = new class_2487();
            game.writeNbt(nbtCompound);
            nbtList.add(nbtCompound);
        }
        nbt.method_10566("Games", nbtList);
        return nbt;
    }

    private int nextId() {return ++nextAvailableId;}
}
