package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.network.OpenScreenPayload;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_6067;

import static net.minecraft.class_1723.*;

public class FullInvScreenHandler extends class_1703 {
    private final class_1263 inventory;
    private final class_1309 target;
    private final boolean editable;
    public final Set<Integer> slotsEnabled; //目标实体的可编辑槽位
    public final int rows; //总行数
    public final int armorRow; //盔甲栏以及副手物品所在的行
    public final boolean notSelf;

    public FullInvScreenHandler(int syncId, class_1661 inv, OpenScreenPayload buf) {
        super(ModItems.FULL_INV_SCREEN_HANDLER, syncId);
        this.inventory = new class_1277(86);
        this.target = (class_1309) inv.field_7546.method_37908().method_8469(buf.id());
        this.editable = buf.bl();
        this.slotsEnabled = setup(inventory, target, editable);
        this.notSelf = inv.field_7546 != target;
        int row = 2, armor = 2; //行数和护甲栏所在行数
        int[] keySlots0 = new int[]{9, 18, 27};
        for (int i : keySlots0) {if (slotsEnabled.contains(i)) armor++;}
        this.armorRow = armor;
        int[] keySlots = new int[]{9, 18, 27, 41, 50, 59, 68, 77};
        for (int i : keySlots) {if (slotsEnabled.contains(i)) row++;}
        this.rows = row;
        int i, j;
        for (i = 0; i < 4; i++) { //物品栏
            for (j = 0; j < 9; j++) {
                int index = j + i * 9; boolean enabled = slotsEnabled.contains(index);
                int x = enabled ? 8 + j * 18 : 114514; int y = enabled ? 18 + i * 18 : 114514;
                method_7621(new class_1735(inventory, index, x, y) {public boolean method_7680(class_1799 stack) {return enabled;}});
            }
        }
        method_7621(new class_1735(inventory, 36, 8 + 4 * 18, 18 * armor) {
            public class_2960 method_7679() {return field_21669;}
        });
        method_7621(new class_1735(inventory, 37, 8 + 5 * 18, 18 * armor) {
            public class_2960 method_7679() {return field_21670;}
        });
        method_7621(new class_1735(inventory, 38, 8 + 6 * 18, 18 * armor) {
            public class_2960 method_7679() {return field_21671;}
        });
        method_7621(new class_1735(inventory, 39, 8 + 7 * 18, 18 * armor) {
            public class_2960 method_7679() {return field_21672;}
        });
        method_7621(new class_1735(inventory, 40, 8 + 8 * 18, 18 * armor) {
            public class_2960 method_7679() {return field_21673;}
        });
        for (i = 0; i < 5; i++) { //饰品栏
            for (j = 0; j < 9; j++) {
                int index = 41 + j + i * 9; boolean enabled = slotsEnabled.contains(index);
                int x = enabled ? 8 + j * 18 : 114514; int y = enabled ? (armor + 1 + i) * 18 : 114514;
                method_7621(new class_1735(inventory, index, x, y) {public boolean method_7680(class_1799 stack) {return enabled;}});
            }
        }
        if (notSelf) addPlayerInventorySlots(inv, rows);
    }

    private static Set<Integer> setup(class_1263 inventory, class_1309 target, boolean editable) {
        Set<Integer> set = new HashSet<>();
        //物品栏
        if (editable) {
            if (target instanceof class_1657 player) {
                var inv = player.method_31548().field_7547;
                for (int i = 0; i < inv.size(); i++) {
                    if (i > 35) break;  // 只取前36个槽位
                    inventory.method_5447(i, inv.get(i));
                    set.add(i);
                }
            } else if (target instanceof class_6067 owner) {
                var stacks = owner.method_35199().field_5828;
                for (int i = 0; i < stacks.size(); i++) {
                    inventory.method_5447(i + 1, stacks.get(i));
                    set.add(i + 1);
                }
            }
        }

        int armorIndex = 0;
        for (class_1799 stack : target.method_5661()) {
            inventory.method_5447(39 - armorIndex, stack); set.add(39 - armorIndex); armorIndex++;
        } //盔甲栏

        if (!(target instanceof class_1657)) {inventory.method_5447(0, target.method_6047()); set.add(0);}
        inventory.method_5447(40, target.method_6079()); set.add(40);

        var trinkets = TrinketsApi.getTrinketComponent(target).map(c -> c.getEquipped(s -> true).stream().map(class_3545::method_15441).toList()).orElse(List.of());
        for (int i = 0; i < trinkets.size(); i++) {
            if (i >= 45) break;
            inventory.method_5447(41 + i, trinkets.get(i));
            set.add(41 + i);
        }
        return set;
    }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (editable) {
            if (button == 114 && !player.method_37908().field_9236) {
                method_7611(slotIndex).method_53512(class_1799.field_8037);
                saveInv(inventory, target);
                return;
            }
            super.method_7593(slotIndex, button, actionType, player);
            saveInv(inventory, target);
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(invSlot);
        if (slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439()) {
                if (!this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }

            if (originalStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }

        return newStack;
    }

    public static void saveInv(class_1263 from, class_1309 to) {
        for (int i = 0; i < 86; i++) {
            class_1799 stack = from.method_5438(i);
            if (i == 0 && !(to instanceof class_1657)) to.method_6122(class_1268.field_5808, stack);
            if (to instanceof class_6067 owner) {
                int size = owner.method_35199().method_5439();
                if (i > 0 && i - 1 < size) owner.method_35199().method_5447(i  - 1, stack);
            }
            if (i < 36 && to instanceof class_1657 player)  player.method_31548().method_5447(i, stack);
            if (i == 36) to.method_5673(class_1304.field_6169, stack);
            if (i == 37) to.method_5673(class_1304.field_6174, stack);
            if (i == 38) to.method_5673(class_1304.field_6172, stack);
            if (i == 39) to.method_5673(class_1304.field_6166, stack);
            if (i == 40) to.method_6122(class_1268.field_5810, stack);
            if (i >= 41) {
                var pair = findSlot(to, i - 41);
                if (pair != null) pair.method_15442().method_5447(pair.method_15441(), stack);
            }
        }
    }

    public static class_3545<TrinketInventory, Integer> findSlot(class_1309 entity, int index) {
        //将饰品栏的每一格添加到一个List中，若index与List中的饰品格的序列号相同，则输出该饰品格
        List<class_3545<TrinketInventory, Integer>> pairs = new ArrayList<>();
        TrinketsApi.getTrinketComponent(entity).ifPresent(component -> component.getInventory().values().forEach(group -> group.values().forEach(inv -> {
            for (int i = 0; i < inv.method_5439(); i++) pairs.add(new class_3545<>(inv, i));
        })));
        for (var pair : pairs) {if (pairs.indexOf(pair) == index) return pair;}
        return null;
    }

    @Override public boolean method_7597(class_1657 player) {return true;}

    private void addPlayerInventorySlots(class_1661 inventory, int rows) {
        int i, j;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.method_7621(new class_1735(inventory, j + i * 9 + 9, 8 + j * 18, 32 + 18 * (rows + i)));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(inventory, i, 8 + i * 18, 36 + 18 * (rows + 3)));
        }
    }
}
