package com.amotassic.dabaosword.util;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.card.Sha;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.network.OpenScreenPayload;
import com.amotassic.dabaosword.ui.FullInvScreenHandler;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1674;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

import static dev.emi.trinkets.api.TrinketsApi.getTrinketComponent;

public class ModTools {
    public static Card c(class_1799 card) {return new Card(card);}
    /**生成一张花色和点数相同，但牌名不同的牌*/
    public static Card c(class_1799 card, CardItem replace) {
        var c = c(card);
        return new Card(replace, c.suit, c.rank);
    }
    public static Skill s(class_1799 skill) {return new Skill(skill);}
    public static ExData d() {return new ExData();}
    //通过predicate寻找对应物品，免得添加标签
    public static Predicate<class_1799> p(class_1792 item) {return s -> s.method_31574(item);}
    //判断是否是卡牌
    public static boolean isCard(class_1799 s) {return s.method_7909() instanceof CardItem;}
    public static final Predicate<class_1799>
            canSaveDying = p(ModItems.JIU).or(p(ModItems.PEACH)),
            isSha = s -> s.method_7909() instanceof Sha,
            isCard = ModTools::isCard,
            isBasic = s -> c(s).type == Card.BASIC,
            isArmoury = s -> c(s).type == Card.ARMOURY,
            isEquipment = s -> c(s).type == Card.EQUIPMENT,
            isDiamondCard = s -> c(s).suit == Suit.Diamond,
            isHeartCard = s -> c(s).suit == Suit.Heart,
            isClubCard = s -> c(s).suit == Suit.Club,
            isSpadeCard = s -> c(s).suit == Suit.Spade,
    isRedCard = isDiamondCard.or(isHeartCard),
    isBlackCard = isClubCard.or(isSpadeCard);

    public static boolean isHuogong(class_1282 source) {
        return source.method_5526() instanceof class_1674 fireball && fireball.method_5752().contains("a");
    }
    public static boolean isShandian(class_1282 source) {
        return source.method_5526() instanceof class_1538 lightning && lightning.method_5752().contains("a");
    }

    @SafeVarargs
    public static <T> List<T> toList(T... t) {return new ArrayList<>(Arrays.asList(t));}

    /**判断是否有某个饰品*/
    public static boolean hasTrinket(class_1792 item, class_1309 entity) {return isEquipped(entity, p(item));}
    public static boolean isEquipped(class_1309 entity, Predicate<class_1799> p) {
        return getTrinketComponent(entity).map(c -> c.isEquipped(p)).orElse(false);
    }

    public static class_1799 trinketItem(class_1792 item, class_1309 entity) {
        return getTrinketComponent(entity).map(c -> c.getEquipped(item).stream().map(class_3545::method_15441).findFirst().orElse(class_1799.field_8037)).orElse(class_1799.field_8037);
    }

    /**获取该实体的所有饰品，输出为ItemStack列表*/
    public static List<class_1799> allTrinkets(class_1309 entity) {
        return getTrinketComponent(entity).map(c -> c.getAllEquipped().stream().map(class_3545::method_15441).toList()).orElse(Collections.emptyList());
    }

    public static CardPileInventory getCardPack(class_1657 player) {
        if (player instanceof class_3222 sp) return PVPGameEvents.PLAYER_CARD_PACKS.getOrDefault(sp, new CardPileInventory(player));
        return new CardPileInventory(player);
    }

    /**判断牌堆和背包中是否有符合条件的卡牌*/
    public static boolean hasCard(class_1309 entity, Predicate<class_1799> predicate) {
        return !getCard(entity, predicate).method_7960();
    }
    /**获取牌堆或背包中的一张符合条件的卡牌*/
    public static class_1799 getCard(class_1309 entity, Predicate<class_1799> predicate) {
        if (entity instanceof class_1657 player) {
            for (class_1799 card : getCardPack(player).cards) {
                if (predicate.test(card)) return card;
            }
        }
        return getItem(entity, predicate);
    }

    /**判断生物是否有某个物品*/
    public static boolean hasItem(@NotNull class_1309 entity, Predicate<class_1799> predicate) {
        return !getItem(entity, predicate).method_7960();
    }
    /**获取玩家背包中第一个符合条件的物品，或者生物的符合条件的主副手物品*/
    public static class_1799 getItem(@NotNull class_1309 entity, Predicate<class_1799> predicate) {
        for (var stack : getItems(entity, predicate, true, false, false, false)) if (predicate.test(stack)) return stack;
        return class_1799.field_8037;
    }

    /**播放语音*/
    public static void voice(class_1309 entity, class_3414 sound, float... volume) {
        if (entity.method_37908() instanceof class_3218 world) {
            float v = volume.length > 0 ? volume[0] : 2;
            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, class_3419.field_15248, v, 1.0F);
        }
    }
    public static void voice(class_1309 entity, class_1792 item, float... volume) {
        voice(entity, class_7923.field_41178.method_10221(item).method_12832(), volume);
    }
    public static void voice(class_1309 entity, class_1799 stack, float... volume) {
        voice(entity, stack.method_7909(), volume);
    }
    public static void voice(class_1309 entity, String name, float... volume) {
        voice(entity, getSound("dabaosword", name), volume);
    }
    public static class_3414 getSound(String namespace, String path) {
        return class_6880.method_40223(class_3414.method_47908(class_2960.method_60655(namespace, path))).comp_349();
    }

    /**数玩家所有手牌的数量*/
    public static int countCards(class_1309 entity) {return countCard(entity, isCard);}
    /**数玩家所有卡牌，包括已装备的牌*/
    public static int countAllCards(class_1309 entity) {return count(entity, isCard, false, true, true);}
    /**数玩家牌堆背包和物品栏的卡牌*/
    public static int countCard(class_1309 entity, Predicate<class_1799> predicate) {
        return count(entity, predicate, false, true, false);
    }
    /**计数*/
    public static int count(class_1309 entity, Predicate<class_1799> predicate, boolean armor, boolean pile, boolean trinkets) {
        int n = 0;
        for (var stack : getItems(entity, predicate, true, armor, trinkets, pile)) n += stack.method_7947();
        return n;
    }

    /**将一个生物的所有符合条件的物品整理成一个list
     * @param main 如果是玩家，包括玩家的物品栏和副手物品，否则只包括生物的主副手物品*/
    public static List<class_1799> getItems(class_1309 entity, Predicate<class_1799> p, boolean main, boolean armor, boolean trinket, boolean pile) {
        List<class_1799> items = new ArrayList<>();
        //如果是玩家则把牌堆中的物品添加到待选物品中
        if (pile && entity instanceof class_1657 player) for (var stack : getCardPack(player).cards) if (p.test(stack)) items.add(stack);
        if (main) { //如果是玩家则把背包和副手的物品添加到待选物品中，否则只添加主副手物品
            if (entity instanceof class_1657 player) {
                for (var stack : player.method_31548().field_7547) if (p.test(stack)) items.add(stack);
            } else if (p.test(entity.method_6047())) items.add(entity.method_6047());
            if (p.test(entity.method_6079())) items.add(entity.method_6079());
        }
        if (armor) for (var stack : entity.method_5661()) if (p.test(stack)) items.add(stack);
        if (trinket) for (var stack : allTrinkets(entity)) if (p.test(stack)) items.add(stack);
        return items;
    }

    public static void draw(class_1309 entity, int... count) {
        int num = count.length > 0 ? count[0] : 1;
        for (int n = 0; n < num; n++) {
            if (entity.method_6059(ModItems.BINGLIANG)) {
                int amplifier = Objects.requireNonNull(entity.method_6112(ModItems.BINGLIANG)).method_5578();
                entity.method_6016(ModItems.BINGLIANG);
                voice(entity, class_3417.field_15008,1);
                if (amplifier != 0) {
                    entity.method_6092(new class_1293(ModItems.BINGLIANG, -1, amplifier - 1));
                } //如果有兵粮寸断效果就不摸牌，改为将debuff等级减一
            } else {
                give(entity, newCard());
                voice(entity, class_3417.field_14627,1);
            }
        }
    }

    public static class_1799 customLoot(class_1309 entity, String path) {
        var key = class_5321.method_29179(class_7924.field_50079, class_2960.method_60655("dabaosword", path));
        AtomicReference<class_1799> stack = new AtomicReference<>(class_1799.field_8037);
        entity.method_64169(world(entity), key, (world, s) -> stack.set(s));
        return stack.get();
    }

    private static final List<class_1799> CARD_PILE = new ArrayList<>();
    public static class_1799 newCard() {
        if (CARD_PILE.isEmpty()) {
            for (class_1799 stack : ALL_CARDS) CARD_PILE.add(stack.method_7972());
            Collections.shuffle(CARD_PILE);
            DabaoSword.LOGGER.info("Shuffled card pile");
        }
        return CARD_PILE.removeFirst();
    }
    public static class_1799 newCard(class_1792 item) {return newCard(p(item));}
    public static class_1799 newCard(Predicate<class_1799> predicate) {
        List<class_1799> list = ALL_CARDS.stream().filter(predicate).toList();
        if (list.isEmpty()) return class_1799.field_8037;
        return list.get(new Random().nextInt(list.size())).method_7972();
    }

    public static void give(class_1309 entity, class_1799 stack) {
        if (entity instanceof class_1657 player) {
            class_1542 item = player.method_7328(stack, false);
            if (item == null) return;
            item.method_5684(true);
            item.method_6975();
            item.method_48349(player.method_5667());
            return;
        }
        if (entity.method_6047().method_7960()) entity.method_6122(class_1268.field_5808, stack);
        else if (entity.method_6079().method_7960()) entity.method_6122(class_1268.field_5810, stack);
    }

    private static final List<class_1799> ALL_CARDS = new ArrayList<>();

    public static void initAllCards() {
        for (CardItem item : ModItems.CARDS) {
            String path = class_7923.field_41178.method_10221(item).method_12832() + ".json";
            Gson gson = new Gson();
            InputStream stream = ModTools.class.getResourceAsStream("/data/dabaosword/default_suit_and_rank/" + path);
            if (stream == null) continue;

            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject json = gson.fromJson(reader, JsonObject.class);
            var srs = json.get("suits_and_ranks").getAsJsonArray();
            for (int j = 0; j < srs.size(); j++) {
                JsonObject sr = srs.get(j).getAsJsonObject();
                String suit = sr.get("suit").getAsString();
                String rank = sr.get("rank").getAsString();

                Card card = new Card(item, Suit.valueOf(suit), Rank.fromString(rank));
                ALL_CARDS.add(card.toStack());
            }
        }
        DabaoSword.LOGGER.info("Loaded {} cards", ALL_CARDS.size());
    }

    public static @Nullable <T extends class_1297> T getClosestEntity(class_1297 entity, Class<T> clazz, double boxLength, Predicate<T> predicate) {
        if (entity.method_37908() instanceof class_3218 world) {
            class_238 box = new class_238(entity.method_24515()).method_1014(boxLength);
            List<T> entities = world.method_8390(clazz, box, predicate.and(e -> e != entity));
            if (!entities.isEmpty()) {
                Map<Float, T> map = new HashMap<>();
                for (var e : entities) {
                    map.put(e.method_5739(entity), e);
                }
                float min = Collections.min(map.keySet());
                return map.get(min);
            }
        }
        return null;
    }

    /**仿照1.20代码写的获取物品NBT的方法*/
    public static class_2487 getOrCreateNbt(class_1799 stack) {
        if (stack.method_7960()) return new class_2487();
        class_9279 component = stack.method_57824(class_9334.field_49628);
        if (component == null) setNbt(stack, new class_2487());
        return Objects.requireNonNull(stack.method_57824(class_9334.field_49628)).method_57461();
    }
    public static void setNbt(class_1799 stack, class_2487 nbt) {
        stack.method_57379(class_9334.field_49628, class_9279.method_57456(nbt));
    }

    public static void openFullInv(class_1657 player, class_1309 target, boolean editable) {
        if (player.method_37908().field_9236) return;
        var payload = new OpenScreenPayload(target.method_5628(), editable, "");
        player.method_17355(new ExtendedScreenHandlerFactory<>() {
            public class_2561 method_5476() {return target.method_5476();}

            public Object getScreenOpeningData(class_3222 player) {return payload;}

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new FullInvScreenHandler(syncId, inv, payload);
            }
        });
    }

    public static void openInv(class_1657 player, class_1309 owner, class_1657 target, class_2561 title, class_1799 stack, boolean equip, boolean armor, int cards) {
        if (player.method_37908().field_9236) return;
        var tempInv = new TempInventory(player, owner, stack, cards, equip, armor);
        var rows = tempInv.rowsToShow;
        player.method_17355(new ExtendedScreenHandlerFactory<>() {
            public class_2561 method_5476() {return title;}

            public Object getScreenOpeningData(class_3222 player) {
                return new OpenScreenPayload(target.method_5628(), true, rows.toString());
            }
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new PlayerInvScreenHandler(syncId, tempInv, target, rows);
            }
        });
    }

    public static void openMenu(class_1657 player, class_1657 target, class_1799 stack, List<class_1799> stacks, class_2561 title) {
        if (player.method_37908().field_9236) return;
        var tempInv = new TempInventory(player, stack, stacks);
        var rows = tempInv.rowsToShow;
        player.method_17355(new ExtendedScreenHandlerFactory<>() {
            public class_2561 method_5476() {return title;}

            public Object getScreenOpeningData(class_3222 player) {
                return new OpenScreenPayload(player.method_5628(), true, rows.toString());
            }
            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return new PlayerInvScreenHandler(syncId, tempInv, target, rows);
            }
        });
    }

    public static class_1799 paibei(int... n) {return new class_1799(ModItems.GAIN_CARD, n.length > 0 ? n[0] : 1);}

    public static void closeGUI(class_1657 player) {
        player.method_6092(new class_1293(ModItems.COOLDOWN2, 1,2,false,false,false));
    }

    public static class_6880<class_1887> getEntry(class_5321<class_1887> key, class_1297... entity) {
        class_1297 e = entity.length > 0 ? entity[0] : null;
        if (e == null) return DabaoSword.server.method_30611().method_30530(class_7924.field_41265).method_46747(key);
        return e.method_56673().method_30530(class_7924.field_41265).method_46747(key);
    }

    public static class_1282 damageSource(class_1297 source, class_5321<class_8110> type) {
        return new class_1282(source.method_37908().method_30349().method_30530(class_7924.field_42534).method_46747(type), source);
    }

    public static void writeDamage(class_1282 source, float amount, boolean returnShan, class_1799 stack) {
        class_2499 list = new class_2499();
        class_2487 compound = new class_2487();
        //noinspection OptionalGetWithoutIsPresent
        compound.method_10582("type", source.method_48793().method_40230().get().method_29177().toString());
        if (source.method_5526() != null) compound.method_10569("source", source.method_5526().method_5628());
        if (source.method_5529() != null) compound.method_10569("attacker", source.method_5529().method_5628());
        compound.method_10548("amount", amount);
        if (returnShan) compound.method_10582("returning", "dabaosword:shan");
        list.add(compound);
        class_2487 nbt = getOrCreateNbt(stack);
        nbt.method_10566("DamageDodged", list);
        setNbt(stack, nbt);
    }
    //牌堆记录闪避伤害的方法
    public static class_3545<class_3545<class_1282, Float>, class_1799> getDamage(class_1657 player) {
        if (player.method_37908() instanceof class_3218 world) {
            class_1799 stack = trinketItem(ModItems.CARD_PILE, player);
            class_2487 compound = getOrCreateNbt(stack);
            if (compound.method_10545("DamageDodged")) {
                class_2487 nbt = ((class_2499) Objects.requireNonNull(compound.method_10580("DamageDodged"))).method_10602(0);
                class_5321<class_8110> type = class_5321.method_29179(class_7924.field_42534, class_2960.method_60654(nbt.method_10558("type")));
                var entry = player.method_37908().method_30349().method_30530(class_7924.field_42534).method_46747(type);
                class_1297 source = world.method_8469(nbt.method_10550("source"));
                class_1297 attacker = world.method_8469(nbt.method_10550("attacker"));
                class_1282 damageSource = new class_1282(entry, source, attacker);
                class_1799 returning = class_1799.field_8037;
                if (nbt.method_10545("returning")) returning = new class_1799(class_7923.field_41178.method_63535(class_2960.method_60654(nbt.method_10558("returning"))));
                float amount = nbt.method_10583("amount");
                return new class_3545<>(new class_3545<>(damageSource, amount), returning);
            }
        }
        return null;
    }

    public static class_3218 world(class_1297 entity) {return (class_3218) entity.method_37908();}

    /**一个用于简便执行多条服务器指令的方法*/
    public static void excuteServerCommand(class_1297 entity, String[] commands, boolean fromServer) {
        if (entity.method_37908() instanceof class_3218 world) {
            var server = world.method_8503();
            var dispatcher = server.method_3734().method_9235();
            var commandSource = fromServer ? server.method_3739() : entity.method_5671(world);
            for (String command : commands) {
                if (command.startsWith("/")) command = command.substring(1);
                try {
                    var results = dispatcher.parse(command, commandSource);
                    dispatcher.execute(results);
                } catch (CommandSyntaxException e) {throw new RuntimeException(e);}
            }
        }
    }

    public static void title(class_3222 player, class_2561 title) {
        player.field_13987.method_14364(new class_5904(title));
    }

    public static void subtitle(class_3222 player, class_2561 sub) {
        player.field_13987.method_14364(new class_5903(sub));
    }

    public static List<class_1309> getSkillOwners(class_1309 entity) {
        if (entity.method_37908().field_9236) return List.of();
        return new ArrayList<>(Objects.requireNonNull(entity.method_5682()).method_3760().method_14571());
    }

    public static List<Skill> getSkillsMayUse(class_1309 entity) {
        Predicate<class_1799> p = s -> {
            if (!(s.method_7909() instanceof ISkill)) return false;
            if (s.method_7909() instanceof SkillItem && entity.method_5752().contains("duanchang")) return false;
            return s(s).lockOn() || !entity.method_6059(ModItems.TIEJI);
        };
        return getTrinketComponent(entity).map(c -> c.getEquipped(p).stream().map(class_3545::method_15441).map(Skill::new).toList()).orElse(Collections.emptyList());
    }

    public static int getResult(Trigger t, class_1309 owner, class_1309 triggered, ExData exData) {
        for (Skill skill : getSkillsMayUse(owner)) {
            for (var data : skill.data()) {
                if (!List.of(data.trigger()).contains(t) || !data.relation().test(owner, triggered, exData.source)) continue;
                int i = data.apply(owner, triggered, skill, exData);
                if (i > 0) return i;
            }
        }
        return 0;
    }

    public static String getTagValue(class_1297 entity, String name) {
        return entity.method_5752().stream().filter(s -> s.startsWith(name + "_")).findFirst().map(s -> s.split("_")[1]).orElse("");
    }
    public static int getTagCount(class_1297 entity, String name) {
        return entity.method_5752().stream().filter(s -> s.startsWith(name + "_")).findFirst().map(s -> Integer.parseInt(s.split("_")[1])).orElse(0);
    }

    public static boolean hasTag(class_1297 entity, String name) {
        return entity.method_5752().stream().anyMatch(s -> s.startsWith(name));
    }

    public static void removeTag(class_1297 entity, String name) {
        var each = entity.method_5752().iterator();
        while (each.hasNext()) { //仅移除第一个符合条件的标签
            if (each.next().startsWith(name)) {
                each.remove(); break;
            }
        }
    }

    public static void addTag(class_1297 entity, String name, int n) {
        removeTag(entity, name);
        entity.method_5780(name + "_" + n);
    }
    public static void addTag(class_1297 entity, String name, String suffix) {
        entity.method_5780(name + "_" + suffix);
    }

}
