/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.data;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.item.card.CardItem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class CardSuitAndRank
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CardSuitAndRank INSTANCE = new CardSuitAndRank();
    public static final List<class_1799> ALL_CARDS = new ArrayList<class_1799>();

    public CardSuitAndRank() {
        super(GSON, "default_suit_and_rank");
    }

    public class_2960 getFabricId() {
        return class_2960.method_43902((String)"dabaosword", (String)"default_suit_and_rank");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ALL_CARDS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            class_2960 key = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(key);
                if (!(item instanceof CardItem)) continue;
                CardItem cardItem = (CardItem)item;
                try {
                    JsonArray srs = jsonElement.getAsJsonObject().get("suits_and_ranks").getAsJsonArray();
                    for (int j = 0; j < srs.size(); ++j) {
                        JsonObject sr = srs.get(j).getAsJsonObject();
                        String suit = sr.get("suit").getAsString();
                        String rank = sr.get("rank").getAsString();
                        Card card = new Card(cardItem, Suit.valueOf(suit), Rank.fromString(rank));
                        ALL_CARDS.add(card.toStack());
                    }
                }
                catch (Exception e) {
                    DabaoSword.LOGGER.error("Missing Element: suits_and_ranks");
                }
            }
            catch (Exception e) {
                DabaoSword.LOGGER.error("No such card registered: {}", (Object)key);
            }
        }
        DabaoSword.LOGGER.info("Loaded {} cards", (Object)ALL_CARDS.size());
    }
}

