/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.card.equipment.Equipment;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class CardEvents {
    public static void cardDiscard(class_1309 entity, ExData exData) {
        exData.forEachCard(1, (c, i) -> ModTools.getResult(Trigger.SHOULD_DISCARD, entity, entity, ModTools.d().cards((Card)c, (int)i, new boolean[0])) > 0);
        exData.forEachCard(2, (c, i) -> ModTools.getResult(Trigger.SHOULD_DISCARD, entity, entity, ModTools.d().cards((Card)c, (int)i, true)) > 0);
        exData.forEachCard(3, (c, i) -> CardEvents.cardDecrement(entity, c.origin(), i));
        ModTools.getSkillOwners(entity).forEach(player -> ModTools.getResult(Trigger.LOSE_CARD_DISCARD, player, entity, exData));
    }

    public static void cardMove(class_1309 from, ExData exData, class_1309 to) {
        exData.forEachCard(3, (c, i) -> {
            CardEvents.cardDecrement(from, c.origin(), i);
            ModTools.give(to, c.toStack().method_46651(i.intValue()));
        });
        ModTools.getSkillOwners(from).forEach(player -> {
            ModTools.getResult(Trigger.LOSE_CARD_MOVE, player, from, exData);
            ModTools.getResult(Trigger.GET_CARD_MOVE, player, to, exData);
        });
    }

    public static void cardToEquip(class_1309 from, ExData exData, class_1309 to) {
        exData.forEachCard(3, (c, i) -> {
            CardEvents.cardDecrement(from, c.origin(), i);
            Equipment.useOrReplaceEquip(to, c.toStack().method_46651(i.intValue()));
        });
        ModTools.getSkillOwners(from).forEach(player -> ModTools.getResult(Trigger.LOSE_CARD_MOVE, player, from, exData));
    }

    public static void hurtByCard(class_1309 entity, class_1282 source, float amount) {
        CardItem card = switch (source.method_48792().comp_1242()) {
            case "huogong" -> ModItems.FIRE_ATTACK;
            case "juedou" -> ModItems.JUEDOU;
            case "nanman" -> ModItems.NANMAN;
            case "wanjian" -> ModItems.WANJIAN;
            case "shandian" -> ModItems.SHANDIAN_ITEM;
            case "sha" -> ModItems.SHA;
            case "shaFire" -> ModItems.FIRE_SHA;
            case "shaThunder" -> ModItems.THUNDER_SHA;
            default -> class_1799.field_8037.method_7909();
        };
        ModTools.getSkillOwners(entity).forEach(player -> ModTools.getResult(Trigger.HURT_BY_CARD, player, entity, ModTools.d().cards(ModTools.newCard(card), 1, new boolean[0]).withDamage(source, Float.valueOf(amount))));
    }

    public static void cardDecrement(class_1309 entity, class_1799 stack, int count) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (ModTools.getCardPack(player).removeStack(stack, count)) {
                return;
            }
            stack.method_7934(count);
            return;
        }
        stack.method_7934(count);
    }

    public static void cardUseAndDecrement(class_1309 user, class_1799 card) {
        if (card.method_31574((class_1792)ModItems.WUXIE)) {
            CardEvents.cardDecrement(user, ModTools.getCard(user, ModTools.p(ModItems.WUXIE)), 1);
        } else {
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                if (player.method_31549().field_7477) {
                    return;
                }
            }
            class_1792 usedItem = card.method_7909();
            class_1799 stack = ModTools.getCard(user, s -> class_1799.method_7973((class_1799)s, (class_1799)card));
            if (stack.method_7960()) {
                stack = ModTools.getCard(user, ModTools.p(usedItem));
            }
            CardEvents.cardDecrement(user, stack, 1);
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                if (stack.method_7947() == 0) {
                    class_1799 s2;
                    if (ModTools.isSha.test(usedItem.method_7854())) {
                        class_1799 s3 = ModTools.getCard(user, ModTools.isSha);
                        if (!s3.method_7960()) {
                            ModTools.give((class_1309)player, s3.method_7972());
                            CardEvents.cardDecrement((class_1309)player, s3, s3.method_7947());
                        }
                    } else if (player.method_6047().method_7960() && !(s2 = ModTools.getCard(user, ModTools.p(usedItem))).method_7960()) {
                        player.method_6122(class_1268.field_5808, s2.method_7972());
                        CardEvents.cardDecrement((class_1309)player, s2, s2.method_7947());
                    }
                }
            }
        }
    }
}

