/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api.skill;

import com.amotassic.dabaosword.api.TriPredicate;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

public interface ISkill
extends Trinket {
    public static final TriPredicate<class_1309, class_1309, class_1282> ANY = (o, t, s) -> true;
    public static final TriPredicate<class_1309, class_1309, class_1282> SELF = (o, t, s) -> o == t;
    public static final TriPredicate<class_1309, class_1309, class_1282> NOT_SELF = (o, t, s) -> o != t;
    public static final TriPredicate<class_1309, class_1309, class_1282> ATTACKER = (o, t, s) -> s != null && s.method_5529() == o;
    public static final TriPredicate<class_1309, class_1309, class_1282> DIRECT_ATTACKER = (o, t, s) -> s != null && s.method_5526() == o;
    public static final TriPredicate<class_1309, class_1309, class_1282> KILLER = (o, t, s) -> t.method_29504() && (s != null && s.method_5529() == o || t.method_6124() == o);

    default public boolean lockOn() {
        return false;
    }

    default public boolean isActiveSkill() {
        return false;
    }

    default public boolean activeSkill(class_1657 user, Skill skill) {
        return false;
    }

    default public boolean activeSkill(class_1657 user, Skill skill, class_1309 target) {
        return false;
    }

    default public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (!this.equipped(stack)) {
                world.method_18456().forEach(player -> player.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.entity.equip", (Object[])new Object[]{entity.method_5476(), stack.method_7954()})));
                this.setEquipped(stack, true);
            }
        }
    }

    default public boolean equipped(class_1799 stack) {
        return ModTools.getOrCreateNbt(stack).method_10545("equipped");
    }

    default public void setEquipped(class_1799 stack, boolean equipped) {
        class_2487 nbt = ModTools.getOrCreateNbt(stack);
        if (equipped) {
            nbt.method_10556("equipped", true);
        } else {
            nbt.method_10551("equipped");
        }
        ModTools.setNbt(stack, nbt);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        class_1937 class_19372;
        if (stack.method_7909() instanceof SkillItem && entity.method_5752().contains("duanchang")) {
            return;
        }
        Skill skill = ModTools.s(stack);
        if (skill.lockOn() || !entity.method_6059(ModItems.TIEJI)) {
            this.tickSkill(skill, entity);
        }
        if (!((class_19372 = entity.method_37908()) instanceof class_3218)) return;
        class_3218 world = (class_3218)class_19372;
        int cd = skill.getCD();
        if (cd <= 0) return;
        if (world.method_8510() % 20L != 0L) return;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7477) {
                skill.setCD(0);
                return;
            }
        }
        skill.setCD(cd - 1);
    }

    default public void tickSkill(Skill skill, class_1309 entity) {
    }

    default public boolean shouldTickUpdate() {
        return false;
    }

    default public void tickUpdateNbt(Skill skill, class_1309 entity) {
        int tick = (int)(entity.method_37908().method_8510() % 20L);
        class_2487 nbt = skill.getNbt();
        nbt.method_10569("TickOfSecond", tick);
        skill.setNbt(nbt);
    }

    default public void addScreenTip(Skill skill, List<class_2561> tips) {
        tips.add(skill.toHoverableText());
        class_1792 class_17922 = skill.stack.method_7909();
        if (class_17922 instanceof SkillItem) {
            SkillItem si = (SkillItem)class_17922;
            si.addTip(skill, tips);
        }
    }

    default public void addPresetTips(Skill skill, List<class_2561> tips, Integer ... presetLines) {
        List<Integer> preset = List.of(presetLines);
        int max = skill.getMaxSelect();
        int min = skill.getMinSelect();
        for (Integer i : preset) {
            switch (i) {
                case 0: {
                    tips.add((class_2561)class_2561.method_43471((String)"screen.dabaosword.title").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}).method_10852((class_2561)class_2561.method_43471((String)"screen.dabaosword.title_").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})));
                    break;
                }
                case 1: {
                    tips.add((class_2561)class_2561.method_43471((String)"screen.dabaosword.tip1").method_27692(class_124.field_1067));
                    break;
                }
                case 2: {
                    tips.add((class_2561)class_2561.method_43471((String)"screen.dabaosword.tip2").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
                    break;
                }
                case 3: {
                    if (max <= 100) break;
                    tips.add((class_2561)class_2561.method_43471((String)"screen.dabaosword.tip3").method_27692(class_124.field_1067));
                    break;
                }
                case 4: {
                    class_5250 text = max >= 100 ? class_2561.method_43471((String)"screen.dabaosword.ctrl_a").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}) : class_2561.method_43470((String)"");
                    tips.add((class_2561)text.method_10852((class_2561)class_2561.method_43471((String)"screen.dabaosword.ctrl_z").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})));
                    break;
                }
                case 5: {
                    class_5250 minText = min > 0 ? class_2561.method_43469((String)"screen.dabaosword.min_tip", (Object[])new Object[]{min}).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}) : class_2561.method_43470((String)"");
                    class_5250 maxText = max < 100 ? class_2561.method_43469((String)"screen.dabaosword.max_tip", (Object[])new Object[]{max}).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}) : class_2561.method_43470((String)"");
                    tips.add((class_2561)minText.method_10852((class_2561)maxText));
                }
            }
        }
    }

    default public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
        if (action == class_1713.field_7790) {
            if (button == 0) {
                handler.addClick(slot, 1);
            }
            if (button == 1) {
                handler.dropClick(slot, 1);
            }
        } else if (action == class_1713.field_7794) {
            if (button == 0) {
                handler.addClick(slot, 99);
            }
            if (button == 1) {
                handler.setClick(slot, 0);
            }
        } else if (action == class_1713.field_7791 && 0 <= button && button < 9) {
            handler.setClick(slot, button + 1);
        }
    }

    default public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
    }

    default public int skillPattern(class_1309 user, class_1309 target, Skill skill, ExData data) {
        return 0;
    }

    default public void preAttack(class_1657 player, class_1309 target, Skill skill) {
    }

    default public int getExtraReach(class_1309 entity, Skill skill) {
        return 0;
    }

    default public int getDefend(class_1309 entity, Skill skill) {
        return 0;
    }

    default public int onDrawPhase(class_1657 player, Skill skill) {
        return 0;
    }
}

