/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.event.PlayerDeathCallback;
import com.amotassic.dabaosword.api.event.PlayerRespawnCallback;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.ModConfig;
import com.amotassic.dabaosword.util.ModTools;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerEvents
implements PlayerDeathCallback,
PlayerRespawnCallback {
    private static final Map<UUID, KillStreakData> playerKillData = new HashMap<UUID, KillStreakData>();

    private static String getKillSound(int streak) {
        return switch (streak) {
            case 1, 2, 3, 4, 5, 6, 7 -> "kill" + streak;
            default -> "diankuang";
        };
    }

    @Override
    public void onDeath(class_3222 player, class_1282 source) {
        class_3218 class_32182 = player.method_51469();
        if (class_32182 instanceof class_3218) {
            Game game;
            Game game2;
            class_3222 killer;
            class_3218 world = class_32182;
            class_1297 attacker = source.method_5529();
            if (!(attacker instanceof class_1657)) {
                attacker = player.method_6124();
            }
            if (ModConfig.KillStreak && attacker instanceof class_3222) {
                KillStreakData data;
                killer = (class_3222)attacker;
                UUID id = killer.method_5667();
                long time = world.method_8510();
                long timeDiff = time - (data = playerKillData.getOrDefault(id, new KillStreakData(0, 0L))).lastKillTime();
                int newStreak = 0L <= timeDiff && timeDiff <= 1200L ? data.streak() + 1 : 1;
                data = new KillStreakData(newStreak, time);
                playerKillData.put(id, data);
                if (data.streak() >= 2) {
                    ModTools.voice((class_1309)killer, PlayerEvents.getKillSound(data.streak()), new float[0]);
                }
            }
            if (attacker instanceof class_3222 && (killer = (class_3222)attacker) != player && (game2 = PVPGameEvents.getGameManager().getGameByPlayer((class_1657)killer)) != null && game2.isOn() && game2.isPlayerInThisGame((class_1657)player)) {
                Map<String, Integer> primaryData = game2.getPrimaryData();
                if (ModConfig.KillStreak && game2.zhongLives + game2.fanLives + game2.neiLives == primaryData.get("zhongLives") + primaryData.get("fanLives") + primaryData.get("neiLives")) {
                    ModTools.voice((class_1309)killer, PlayerEvents.getKillSound(1), new float[0]);
                }
                Game.Identity killerTeam = game2.getIdentity(killer);
                Game.Identity deadTeam = game2.getIdentity(player);
                if (deadTeam != Game.Identity.NEI && killerTeam != deadTeam) {
                    game2.increaseScore(killer);
                }
            }
            if ((game = PVPGameEvents.getGameManager().getGameByPlayer((class_1657)player)) != null && game.isOn()) {
                game.decreaseLives(player);
                Game.Identity identity = game.getIdentity(player);
                int re = game.getRespawnChances(identity);
                if (re <= 0) {
                    player.method_7336(class_1934.field_9219);
                    game.forEachPlayer(p -> p.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.game.view_id.tip", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)identity.tag)}).method_27695(new class_124[]{Game.getIdentityColor(identity), class_124.field_1067})));
                }
            }
            if (world.method_64395().method_8355(Gamerule.CLEAR_CARDS_AFTER_DEATH)) {
                CardEvents.cardDiscard((class_1309)player, PlayerEvents.cardsToDrop((class_1657)player));
            }
            if (ModTools.hasItem((class_1309)player, ModTools.p(ModItems.BBJI))) {
                ModTools.voice((class_1309)player, "xuyou", new float[0]);
            }
            player.method_5752().remove("duanchang");
        }
    }

    public static ExData cardsToDrop(class_1657 player) {
        ExData data = ModTools.d();
        CardPileInventory inventory = ModTools.getCardPack(player);
        for (class_1799 stack : inventory.cards) {
            data.cards(stack, stack.method_7947(), new boolean[0]);
        }
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (!ModTools.isCard(stack)) continue;
            data.cards(stack, stack.method_7947(), new boolean[0]);
        }
        for (class_1799 stack : ModTools.allTrinkets((class_1309)player)) {
            if (!ModTools.isCard(stack)) continue;
            data.cards(stack, stack.method_7947(), true);
        }
        return data;
    }

    @Override
    public void onPlayerRespawn(class_3222 oldPlayer, class_3222 player) {
        class_3218 world;
        boolean card;
        class_3218 class_32182 = player.method_51469();
        if (class_32182 instanceof class_3218 && (card = (world = class_32182).method_64395().method_8355(Gamerule.CLEAR_CARDS_AFTER_DEATH)) && ModTools.hasTrinket(ModItems.CARD_PILE, (class_1309)player)) {
            ModTools.give((class_1309)player, ModTools.newCard(ModItems.SHA));
            ModTools.give((class_1309)player, ModTools.newCard(ModItems.SHAN));
            ModTools.give((class_1309)player, ModTools.newCard(ModItems.PEACH));
            ModTools.draw((class_1309)player, new int[0]);
        }
    }

    private record KillStreakData(int streak, long lastKillTime) {
    }
}

