/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.network.OpenScreenPayload;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.TempInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class PlayerInvScreenHandler
extends class_1703 {
    private final class_1657 target;
    private final TempInventory inv;
    private final class_1799 stack;
    private final Skill skill;
    private final List<Integer> clicks = new ArrayList<Integer>();
    public final int rows;

    public PlayerInvScreenHandler(int syncId, class_1661 inv, OpenScreenPayload buf) {
        this(syncId, new TempInventory(inv.field_7546, ModTools.paibei(new int[0]), List.of()), (class_1657)inv.field_7546.method_37908().method_8469(buf.id()), PlayerInvScreenHandler.stringToSet(buf.str()));
    }

    private static Set<Integer> stringToSet(String str) {
        String trimmed = str.substring(1, str.length() - 1);
        String[] parts = trimmed.split(", ");
        HashSet<Integer> set = new HashSet<Integer>();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            set.add(Integer.parseInt(part));
        }
        return set;
    }

    public PlayerInvScreenHandler(int syncId, TempInventory inventory, class_1657 target, Set<Integer> rowsToShow) {
        super(ModItems.PLAYER_INV_SCREEN_HANDLER, syncId);
        this.target = target;
        this.inv = inventory;
        this.stack = this.inv.method_5438(81);
        this.skill = ModTools.s(this.stack);
        this.rows = rowsToShow.size();
        int line = 0;
        for (int j = 0; j < 9; ++j) {
            int i;
            if (rowsToShow.contains(j)) {
                if (j == 0) {
                    for (i = 0; i < 4; ++i) {
                        this.method_7621(new class_1735((class_1263)this.inv, i, 8 + i * 18, 18));
                    }
                    this.method_7621(new class_1735(this, (class_1263)this.inv, 4, 80, 18){

                        public class_2960 method_7679() {
                            return class_1723.field_21669;
                        }
                    });
                    this.method_7621(new class_1735(this, (class_1263)this.inv, 5, 98, 18){

                        public class_2960 method_7679() {
                            return class_1723.field_21670;
                        }
                    });
                    this.method_7621(new class_1735(this, (class_1263)this.inv, 6, 116, 18){

                        public class_2960 method_7679() {
                            return class_1723.field_21671;
                        }
                    });
                    this.method_7621(new class_1735(this, (class_1263)this.inv, 7, 134, 18){

                        public class_2960 method_7679() {
                            return class_1723.field_21672;
                        }
                    });
                    this.method_7621(new class_1735(this, (class_1263)this.inv, 8, 152, 18){

                        public class_2960 method_7679() {
                            return class_1723.field_21673;
                        }
                    });
                } else {
                    for (i = 0; i < 9; ++i) {
                        this.method_7621(new class_1735((class_1263)this.inv, i + j * 9, 8 + i * 18, 18 + line * 18));
                    }
                }
                ++line;
                continue;
            }
            for (i = 0; i < 9; ++i) {
                this.method_7621(new class_1735((class_1263)this.inv, i + j * 9, 114514, 114514));
            }
        }
        this.inv.method_5447(82, ModTools.paibei(new int[0]));
        for (int i = 0; i < 2; ++i) {
            this.method_7621(new class_1735((class_1263)this.inv, 81 + i, 114514, 114514));
        }
    }

    public void method_7593(int index, int button, class_1713 action, class_1657 player) {
        if (index >= 0 && index < 81 && !player.method_37908().field_9236) {
            class_1799 selected = this.getStack(index);
            if (button == 65 && this.maxSelect() >= 100) {
                this.forEachNonEmptySlot(s -> this.addClick(s.method_34266(), 99));
            }
            if (button == 90) {
                this.forEachNonEmptySlot(s -> this.setClick(s.method_34266(), 0));
            }
            if (!selected.method_7960()) {
                this.skill.item.onSlotClick(this, player, this.skill, this.target, index, button, action);
            }
            this.writeClicks();
            if (this.stack.method_7960()) {
                class_1799 mainHand = player.method_6047();
                class_1799 mainCopy = mainHand.method_7972();
                class_1799 copy = selected.method_7972();
                if (!selected.method_7960() && !class_1799.method_7973((class_1799)mainHand, (class_1799)selected)) {
                    mainHand.method_7939(0);
                    selected.method_7939(0);
                    if (index >= 45) {
                        ModTools.getCardPack(player).method_5441(index - 45);
                    }
                    player.method_6122(class_1268.field_5808, copy);
                    ModTools.give((class_1309)player, mainCopy);
                }
                ModTools.closeGUI(player);
            }
            if (!selected.method_7960()) {
                ExData exData;
                class_5250 message;
                if (this.stack.method_31574((class_1792)ModItems.STEAL)) {
                    message = class_2561.method_43469((String)"dabaosword.steal", (Object[])new Object[]{player.method_5476(), this.target.method_5476(), selected.method_7954()});
                    player.method_7353((class_2561)message, false);
                    this.target.method_7353((class_2561)message, false);
                    if (ModTools.isCard(selected)) {
                        exData = ModTools.d().cards(selected, 1, index < 4);
                        CardEvents.cardMove((class_1309)this.target, exData, (class_1309)player);
                    } else {
                        ModTools.give((class_1309)player, selected.method_46651(1));
                        selected.method_7934(1);
                    }
                    ModTools.closeGUI(player);
                }
                if (this.stack.method_31574((class_1792)ModItems.DISCARD)) {
                    message = class_2561.method_43469((String)"dabaosword.discard", (Object[])new Object[]{player.method_5476(), this.target.method_5476(), selected.method_7954()});
                    player.method_7353((class_2561)message, false);
                    this.target.method_7353((class_2561)message, false);
                    exData = ModTools.d().cards(selected, 1, index < 4);
                    CardEvents.cardDiscard((class_1309)this.target, exData);
                    ModTools.closeGUI(player);
                }
            }
        }
    }

    public void method_7595(class_1657 player) {
        this.skill.item.onGuiClose(this, player, this.skill, this.target);
    }

    public class_1799 getStack(int slot) {
        class_1309 class_13092;
        if (slot < 0 || slot > 80) {
            return class_1799.field_8037;
        }
        class_1799 item = this.inv.method_5438(slot);
        if (this.inv.type == 1 && item.method_31574(ModItems.GAIN_CARD) && (class_13092 = this.inv.owner) instanceof class_1657) {
            class_1657 pl = (class_1657)class_13092;
            if (slot < 45) {
                return (class_1799)pl.method_31548().method_67533().get(slot - 9);
            }
            return (class_1799)ModTools.getCardPack((class_1657)pl).cards.get(slot - 45);
        }
        return item;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        class_1293 effect = player.method_6112(ModItems.COOLDOWN2);
        return effect == null || effect.method_5578() != 2;
    }

    public void forEachNonEmptySlot(Consumer<class_1735> action) {
        for (int i = 0; i < 81; ++i) {
            class_1735 slot = this.method_7611(i);
            if (!slot.method_7681()) continue;
            action.accept(slot);
        }
    }

    private void writeClicks() {
        class_1799 cinfo = this.method_7611(82).method_7677();
        class_2487 nbt = new class_2487();
        nbt.method_10582("Clicks", this.getClickMap().toString());
        ModTools.setNbt(cinfo, nbt);
    }

    public int maxSelect() {
        return this.skill.getMaxSelect();
    }

    private int getSlotClicked(int slot) {
        if (!this.clicks.contains(slot)) {
            return 0;
        }
        return this.getClickMap().get(slot);
    }

    public void addClick(int slot, int ... count) {
        int num = count.length > 0 ? count[0] : 1;
        int n = this.method_7611(slot).method_7677().method_7947();
        num = Math.min(n - this.getSlotClicked(slot), num);
        for (int i = 0; i < num; ++i) {
            this.clicks.add(slot);
            if (this.getSelectedCount() <= this.maxSelect()) continue;
            this.dropFirst(new int[0]);
        }
    }

    public void dropClick(int slot, int ... count) {
        if (!this.clicks.contains(slot)) {
            return;
        }
        int num = count.length > 0 ? count[0] : 1;
        for (int i = 0; i < num && this.clicks.remove((Object)slot); ++i) {
        }
    }

    public void setClick(int slot, int count) {
        if (this.clicks.contains(slot)) {
            this.dropClick(slot, 114514);
        }
        if (count > 0) {
            this.addClick(slot, count);
        }
    }

    public void dropFirst(int ... count) {
        if (this.clicks.isEmpty()) {
            return;
        }
        this.dropClick(this.clicks.getFirst(), count);
    }

    public int getSelectedCount() {
        return this.clicks.size();
    }

    public List<class_1799> getSelected() {
        ArrayList<class_1799> selected = new ArrayList<class_1799>();
        this.clicks.forEach(slot -> {
            class_1799 stack = this.method_7611((int)slot).method_7677();
            if (!stack.method_7960()) {
                selected.add(stack.method_46651(1));
            }
        });
        return selected;
    }

    public Map<Integer, Integer> getClickMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Integer num : this.clicks) {
            if (map.containsKey(num)) {
                map.put(num, (Integer)map.get(num) + 1);
                continue;
            }
            map.put(num, 1);
        }
        return map;
    }

    public ExData toExData() {
        ExData exData = ModTools.d();
        Map<Integer, Integer> clickMap = this.getClickMap();
        clickMap.forEach((slot, count) -> {
            class_1799 stack = this.getStack((int)slot);
            if (ModTools.isCard(stack)) {
                exData.cards(stack, (int)count, slot < 4);
            }
        });
        return exData;
    }
}

