/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillExecutor;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.card.equipment.Equipment;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CardEvents {
    private static void triggerCardSkillBeforeDiscard(LivingEntity owner, ExData exData, Trigger t) {
        exData.forEachCard(2, (c, i) -> {
            ItemStack stack = c.toStack();
            if (stack.getItem() instanceof Equipment) {
                Skill skill = ModTools.s(stack);
                for (SkillExecutor data : skill.data()) {
                    if (!List.of(data.trigger()).contains((Object)t) || !data.relation().test(owner, owner, exData.source)) continue;
                    data.apply(owner, owner, skill, exData);
                }
            }
        });
    }

    public static void cardDiscard(LivingEntity entity, ExData exData) {
        exData.forEachCard(1, (c, i) -> ModTools.getResult(Trigger.SHOULD_DISCARD, entity, entity, ModTools.d().cards((Card)c, (int)i, new boolean[0])) > 0);
        exData.forEachCard(2, (c, i) -> ModTools.getResult(Trigger.SHOULD_DISCARD, entity, entity, ModTools.d().cards((Card)c, (int)i, true)) > 0);
        CardEvents.triggerCardSkillBeforeDiscard(entity, exData, Trigger.LOSE_CARD_DISCARD);
        exData.forEachCard(3, (c, i) -> CardEvents.cardDecrement(entity, c.origin(), i));
        ModTools.getSkillOwners(entity).forEach(player -> ModTools.getResult(Trigger.LOSE_CARD_DISCARD, player, entity, exData));
    }

    public static void cardMove(LivingEntity from, ExData exData, LivingEntity to) {
        CardEvents.triggerCardSkillBeforeDiscard(from, exData, Trigger.LOSE_CARD_MOVE);
        exData.forEachCard(3, (c, i) -> {
            CardEvents.cardDecrement(from, c.origin(), i);
            ModTools.give(to, c.toStack().copyWithCount(i.intValue()), new int[0]);
        });
        ModTools.getSkillOwners(from).forEach(player -> {
            ModTools.getResult(Trigger.LOSE_CARD_MOVE, player, from, exData);
            ModTools.getResult(Trigger.GET_CARD_MOVE, player, to, exData);
        });
    }

    public static void cardToEquip(LivingEntity from, ExData exData, LivingEntity to) {
        CardEvents.triggerCardSkillBeforeDiscard(from, exData, Trigger.LOSE_CARD_MOVE);
        exData.forEachCard(3, (c, i) -> {
            CardEvents.cardDecrement(from, c.origin(), i);
            Equipment.useOrReplaceEquip(to, c.toStack().copyWithCount(i.intValue()));
        });
        ModTools.getSkillOwners(from).forEach(player -> ModTools.getResult(Trigger.LOSE_CARD_MOVE, player, from, exData));
    }

    public static void hurtByCard(LivingEntity entity, DamageSource source, float amount) {
        CardItem card = switch (source.type().msgId()) {
            case "huogong" -> ModItems.FIRE_ATTACK;
            case "juedou" -> ModItems.JUEDOU;
            case "nanman" -> ModItems.NANMAN;
            case "wanjian" -> ModItems.WANJIAN;
            case "shandian" -> ModItems.SHANDIAN_ITEM;
            case "sha" -> ModItems.SHA;
            case "shaFire" -> ModItems.FIRE_SHA;
            case "shaThunder" -> ModItems.THUNDER_SHA;
            default -> ItemStack.EMPTY.getItem();
        };
        ModTools.getSkillOwners(entity).forEach(player -> ModTools.getResult(Trigger.HURT_BY_CARD, player, entity, ModTools.d().cards(ModTools.newCard(card), 1, new boolean[0]).withDamage(source, Float.valueOf(amount))));
    }

    public static void cardDecrement(LivingEntity entity, ItemStack stack, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ModTools.getCardPack(player).removeStack(stack, count)) {
                return;
            }
            stack.shrink(count);
            return;
        }
        stack.shrink(count);
    }

    public static void cardUseAndDecrement(LivingEntity user, ItemStack card, InteractionHand hand) {
        if (card.is((Item)ModItems.WUXIE)) {
            CardEvents.cardDecrement(user, ModTools.getCard(user, ModTools.p(ModItems.WUXIE)), 1);
        } else {
            if (user instanceof Player) {
                Player player = (Player)user;
                if (player.getAbilities().instabuild) {
                    return;
                }
            }
            Item usedItem = card.getItem();
            ItemStack stack = ModTools.getCard(user, s -> ItemStack.matches((ItemStack)s, (ItemStack)card));
            if (stack.isEmpty()) {
                stack = ModTools.getCard(user, ModTools.p(usedItem));
            }
            CardEvents.cardDecrement(user, stack, 1);
            if (user instanceof Player) {
                Player player = (Player)user;
                if (stack.isEmpty()) {
                    ItemStack s2;
                    if (ModTools.isSha.test(usedItem.getDefaultInstance())) {
                        ItemStack s3 = ModTools.getCard(user, ModTools.isSha);
                        if (!s3.isEmpty()) {
                            if (hand != null) {
                                player.setItemInHand(hand, s3.copy());
                            } else {
                                ModTools.give((LivingEntity)player, s3.copy(), new int[0]);
                            }
                            CardEvents.cardDecrement((LivingEntity)player, s3, s3.getCount());
                        }
                    } else if (hand != null && player.getItemInHand(hand).isEmpty() && !(s2 = ModTools.getCard(user, ModTools.p(usedItem))).isEmpty()) {
                        player.setItemInHand(hand, s2.copy());
                        CardEvents.cardDecrement((LivingEntity)player, s2, s2.getCount());
                    }
                }
            }
        }
    }
}

