/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CardPileInventory
implements Container {
    public NonNullList<ItemStack> cards;
    public Player player;
    private static final Item pile = ModItems.CARD_PILE;

    public CardPileInventory(Player player) {
        this.player = player;
        this.cards = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        this.readNbt();
    }

    public void stopOpen(@NotNull Player player) {
        this.writeNbtToStack();
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (!((ItemStack)this.cards.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void readNbt() {
        ListTag list = ModTools.getOrCreateNbt(ModTools.trinketItem(pile, (LivingEntity)this.player)).getList("Items", 10);
        this.readNbt(list);
    }

    public void readNbt(ListTag nbtList) {
        this.cards.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            byte j = nbtCompound.getByte("Slot");
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)this.player.registryAccess(), (Tag)nbtCompound).orElse(ItemStack.EMPTY);
            if (itemStack.isEmpty() || j < 0 || j >= this.getContainerSize()) continue;
            this.setItem(j, itemStack);
        }
    }

    public void writeNbtToStack() {
        CompoundTag nbtCompound;
        if (this.player.level().isClientSide) {
            return;
        }
        ListTag nbtList = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (((ItemStack)this.cards.get(i)).isEmpty()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.putByte("Slot", (byte)i);
            nbtList.add((Object)((ItemStack)this.cards.get(i)).save((HolderLookup.Provider)this.player.registryAccess(), (Tag)nbtCompound));
        }
        ItemStack stack = ModTools.trinketItem(pile, (LivingEntity)this.player);
        nbtCompound = ModTools.getOrCreateNbt(stack);
        nbtCompound.put("Items", (Tag)nbtList);
        ModTools.setNbt(stack, nbtCompound);
    }

    public int getContainerSize() {
        return this.cards.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.cards) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isNotFull() {
        for (ItemStack itemStack : this.cards) {
            if (!itemStack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.cards.get(slot);
    }

    public int getSlotWith(ItemStack stack) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.isEmpty() || !ItemStack.matches((ItemStack)itemStack, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeStack(ItemStack stack, int count) {
        int i = this.getSlotWith(stack);
        if (i == -1) {
            return false;
        }
        this.removeItem(i, count);
        return true;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = ContainerHelper.removeItem(this.cards, (int)slot, (int)amount);
        this.writeNbtToStack();
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = (ItemStack)this.cards.get(slot);
        this.cards.set(slot, (Object)ItemStack.EMPTY);
        this.writeNbtToStack();
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.cards.set(slot, (Object)stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.cards.clear();
        this.writeNbtToStack();
    }

    public void insertStack(ItemStack stack) {
        if (this.insertStack(-1, stack)) {
            this.writeNbtToStack();
        }
    }

    public boolean insertStack(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!stack.isDamaged()) {
            int i;
            do {
                i = stack.getCount();
                if (slot == -1) {
                    stack.setCount(this.addStack(stack));
                    continue;
                }
                stack.setCount(this.addStack(slot, stack));
            } while (!stack.isEmpty() && stack.getCount() < i);
            return stack.getCount() < i;
        }
        if (slot == -1) {
            slot = this.getEmptySlot();
        }
        if (slot >= 0) {
            this.cards.set(slot, (Object)stack.copyAndClear());
            return true;
        }
        return false;
    }

    private int addStack(ItemStack stack) {
        int i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) {
            i = this.getEmptySlot();
        }
        if (i == -1) {
            return stack.getCount();
        }
        return this.addStack(i, stack);
    }

    private int addStack(int slot, ItemStack stack) {
        int j;
        int k;
        int i = stack.getCount();
        ItemStack itemStack = this.getItem(slot);
        if (itemStack.isEmpty()) {
            itemStack = stack.copyWithCount(0);
            this.setItem(slot, itemStack);
        }
        if ((k = Math.min(i, j = this.getMaxStackSize(itemStack) - itemStack.getCount())) != 0) {
            i -= k;
            itemStack.grow(k);
        }
        return i;
    }

    public int getOccupiedSlotWithRoomForStack(ItemStack stack) {
        for (int i = 0; i < this.cards.size(); ++i) {
            if (!this.canStackAddMore((ItemStack)this.cards.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    private boolean canStackAddMore(ItemStack existingStack, ItemStack stack) {
        return !existingStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)stack) && existingStack.isStackable() && existingStack.getCount() < this.getMaxStackSize(existingStack);
    }
}

