/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api.card;

import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class Card {
    private final ItemStack card;
    private final ItemStack copy;
    private final CardItem item;
    public final int type;
    public final Suit suit;
    public final Rank rank;
    public int count;
    public static final int BASIC = 0;
    public static final int ARMOURY = 1;
    public static final int EQUIPMENT = 2;

    public Card(CardItem item, Suit suit, Rank rank) {
        this.card = this.copy = ItemStack.EMPTY;
        this.item = item;
        this.type = item.getType();
        this.suit = suit;
        this.rank = rank;
        this.count = 1;
    }

    public Card(CardItem item) {
        this(item, Suit.None, Rank.None);
    }

    public Card(ItemStack card) {
        CardItem c;
        this.card = card;
        this.copy = card.copy();
        Item item = card.getItem();
        this.item = item instanceof CardItem ? (c = (CardItem)item) : ModItems.EMPTY_CARD;
        this.type = this.item.getType();
        this.count = card.getCount();
        CompoundTag nbt = ModTools.getOrCreateNbt(card);
        this.suit = this.count == 0 ? Suit.None : Suit.fromNbt(nbt);
        this.rank = this.count == 0 ? Rank.None : Rank.fromNbt(nbt);
    }

    public CardItem item() {
        return this.item;
    }

    public boolean isFromStack() {
        return !this.copy.isEmpty();
    }

    public ItemStack origin() {
        return this.card;
    }

    public ItemStack toStack() {
        if (this.isFromStack()) {
            return this.copy.copy();
        }
        ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
        CompoundTag nbt = new CompoundTag();
        if (this.suit != Suit.None) {
            nbt.putString("Suit", this.suit.name());
        }
        if (this.rank != Rank.None) {
            nbt.putString("Rank", this.rank.rank);
        }
        ModTools.setNbt(stack, nbt);
        return stack;
    }

    public boolean askForWuxie() {
        CardItem cardItem = this.item;
        if (cardItem instanceof CardItem.Armoury) {
            CardItem.Armoury a = (CardItem.Armoury)cardItem;
            return a.askForWuxie();
        }
        return false;
    }

    public void effect(LivingEntity user, ItemStack card, LivingEntity target) {
        this.item.effect(user, card, target);
    }

    public boolean isOf(Item item) {
        return this.item == item;
    }

    public Component getName() {
        return this.item.getDescription();
    }

    public String toString() {
        return String.valueOf(this.card) + ", suit=" + String.valueOf((Object)this.suit) + ", rank=" + String.valueOf((Object)this.rank);
    }
}

