/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api.skill;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ExData {
    public List<LivingEntity> targets;
    public DamageSource source;
    public Float amount;
    public final Map<Card, Integer> cards_from_inv = new HashMap<Card, Integer>();
    public final Map<Card, Integer> cards_from_equ = new HashMap<Card, Integer>();
    public final List<Float> adds = new ArrayList<Float>();
    public final List<Float> muls = new ArrayList<Float>();
    public static final int FROM_INV = 1;
    public static final int FROM_EQUIP = 2;
    public static final int ALL = 3;

    public ExData withTargets(LivingEntity ... targets) {
        this.targets = ModTools.toList(targets);
        return this;
    }

    public void removeTarget(LivingEntity entity) {
        if (this.targets == null) {
            return;
        }
        while (this.targets.contains(entity)) {
            this.targets.remove(entity);
        }
    }

    public ExData withDamage(DamageSource source, Float amount) {
        this.source = source;
        this.amount = amount;
        return this;
    }

    public ExData cards(ItemStack card, int count, boolean ... fromEquip) {
        return this.cards(ModTools.c(card), count, fromEquip);
    }

    public ExData cards(Card card, int count, boolean ... fromEquip) {
        boolean bl;
        boolean bl2 = bl = fromEquip.length > 0 && fromEquip[0];
        if (bl) {
            this.cards_from_equ.put(card, count);
        } else {
            for (Card c : this.cards_from_inv.keySet()) {
                if (!ItemStack.matches((ItemStack)c.toStack(), (ItemStack)card.toStack())) continue;
                Integer stored = this.cards_from_inv.get(c);
                int stackCount = c.count;
                if (stored == stackCount) continue;
                this.cards_from_inv.put(c, Math.min(stored + count, stackCount));
                if ((count -= stackCount - stored) > 0) continue;
                return this;
            }
            this.cards_from_inv.put(card, count);
        }
        return this;
    }

    public void clearCards(LivingEntity cards_owner) {
        this.forEachCard(3, (Card c, Integer i) -> CardEvents.cardDecrement(cards_owner, c.origin(), i));
    }

    public Card getFirst(boolean ... fromEquip) {
        boolean bl;
        boolean bl2 = bl = fromEquip.length > 0 && fromEquip[0];
        if (bl && !this.cards_from_equ.isEmpty()) {
            return this.cards_from_equ.keySet().iterator().next();
        }
        if (!this.cards_from_inv.isEmpty()) {
            return this.cards_from_inv.keySet().iterator().next();
        }
        return new Card(ModItems.EMPTY_CARD);
    }

    public boolean noCard() {
        return this.cards_from_inv.isEmpty() && this.cards_from_equ.isEmpty();
    }

    public void forEachCard(int from, BiFunction<Card, Integer, Boolean> func) {
        if (this.noCard()) {
            return;
        }
        if (from == 1 || from == 3) {
            this.cards_from_inv.keySet().removeIf(c -> (Boolean)func.apply((Card)c, this.cards_from_inv.get(c)));
        }
        if (from == 2 || from == 3) {
            this.cards_from_equ.keySet().removeIf(c -> (Boolean)func.apply((Card)c, this.cards_from_equ.get(c)));
        }
    }

    public void forEachCard(int from, BiConsumer<Card, Integer> consum) {
        if (this.noCard()) {
            return;
        }
        if (from == 1 || from == 3) {
            this.cards_from_inv.forEach(consum);
        }
        if (from == 2 || from == 3) {
            this.cards_from_equ.forEach(consum);
        }
    }
}

