/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api.skill;

import com.amotassic.dabaosword.api.TriPredicate;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public interface ISkill
extends ICurioItem {
    public static final TriPredicate<LivingEntity, LivingEntity, DamageSource> ANY = (o, t, s) -> true;
    public static final TriPredicate<LivingEntity, LivingEntity, DamageSource> SELF = (o, t, s) -> o == t;
    public static final TriPredicate<LivingEntity, LivingEntity, DamageSource> NOT_SELF = (o, t, s) -> o != t;
    public static final TriPredicate<LivingEntity, LivingEntity, DamageSource> ATTACKER = (o, t, s) -> s != null && s.getEntity() == o;
    public static final TriPredicate<LivingEntity, LivingEntity, DamageSource> DIRECT_ATTACKER = (o, t, s) -> s != null && s.getDirectEntity() == o;
    public static final TriPredicate<LivingEntity, LivingEntity, DamageSource> KILLER = (o, t, s) -> t.isDeadOrDying() && (s != null && s.getEntity() == o || t.getKillCredit() == o);

    default public boolean lockOn() {
        return false;
    }

    default public boolean isActiveSkill() {
        return false;
    }

    default public boolean activeSkill(Player user, Skill skill) {
        return false;
    }

    default public boolean activeSkill(Player user, Skill skill, LivingEntity target) {
        return false;
    }

    default public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!this.equipped(stack)) {
                world.players().forEach(player -> player.displayClientMessage((Component)Component.translatable((String)"dabaosword.entity.equip", (Object[])new Object[]{entity.getDisplayName(), stack.getDisplayName()}), false));
                this.setEquipped(stack, true);
            }
        }
    }

    default public boolean equipped(ItemStack stack) {
        return ModTools.getOrCreateNbt(stack).contains("equipped");
    }

    default public void setEquipped(ItemStack stack, boolean equipped) {
        CompoundTag nbt = ModTools.getOrCreateNbt(stack);
        if (equipped) {
            nbt.putBoolean("equipped", true);
        } else {
            nbt.remove("equipped");
        }
        ModTools.setNbt(stack, nbt);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public void curioTick(SlotContext slotContext, ItemStack stack) {
        Level level;
        LivingEntity entity = slotContext.entity();
        if (stack.getItem() instanceof SkillItem && entity.getTags().contains("duanchang")) {
            return;
        }
        Skill skill = ModTools.s(stack);
        if (skill.lockOn() || !entity.hasEffect(ModItems.TIEJI)) {
            this.tickSkill(skill, entity);
        }
        if (!((level = entity.level()) instanceof ServerLevel)) return;
        ServerLevel world = (ServerLevel)level;
        int cd = skill.getCD();
        if (cd <= 0) return;
        if (world.getGameTime() % 20L != 0L) return;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                skill.setCD(0);
                return;
            }
        }
        skill.setCD(cd - 1);
    }

    default public void tickSkill(Skill skill, LivingEntity entity) {
    }

    default public boolean shouldTickUpdate() {
        return false;
    }

    default public void tickUpdateNbt(Skill skill, LivingEntity entity) {
        int tick = (int)(entity.level().getGameTime() % 20L);
        CompoundTag nbt = skill.getNbt();
        nbt.putInt("TickOfSecond", tick);
        skill.setNbt(nbt);
    }

    default public void addScreenTip(Skill skill, List<Component> tips) {
        tips.add(skill.toHoverableText());
        Item item = skill.stack.getItem();
        if (item instanceof SkillItem) {
            SkillItem si = (SkillItem)item;
            si.addTip(skill, tips);
        }
    }

    default public void addPresetTips(Skill skill, List<Component> tips, Integer ... presetLines) {
        List<Integer> preset = List.of(presetLines);
        int max = skill.getMaxSelect();
        int min = skill.getMinSelect();
        for (Integer i : preset) {
            switch (i) {
                case 0: {
                    tips.add((Component)Component.translatable((String)"screen.dabaosword.title").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}).append((Component)Component.translatable((String)"screen.dabaosword.title_").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
                    break;
                }
                case 1: {
                    tips.add((Component)Component.translatable((String)"screen.dabaosword.tip1").withStyle(ChatFormatting.BOLD));
                    break;
                }
                case 2: {
                    tips.add((Component)Component.translatable((String)"screen.dabaosword.tip2").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
                    break;
                }
                case 3: {
                    if (max <= 100) break;
                    tips.add((Component)Component.translatable((String)"screen.dabaosword.tip3").withStyle(ChatFormatting.BOLD));
                    break;
                }
                case 4: {
                    MutableComponent text = max >= 100 ? Component.translatable((String)"screen.dabaosword.ctrl_a").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}) : Component.literal((String)"");
                    tips.add((Component)text.append((Component)Component.translatable((String)"screen.dabaosword.ctrl_z").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
                    break;
                }
                case 5: {
                    MutableComponent minText = min > 0 ? Component.translatable((String)"screen.dabaosword.min_tip", (Object[])new Object[]{min}).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}) : Component.literal((String)"");
                    MutableComponent maxText = max < 100 ? Component.translatable((String)"screen.dabaosword.max_tip", (Object[])new Object[]{max}).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}) : Component.literal((String)"");
                    tips.add((Component)minText.append((Component)maxText));
                }
            }
        }
    }

    default public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
        if (action == ClickType.PICKUP) {
            if (button == 0) {
                handler.addClick(slot, 1);
            }
            if (button == 1) {
                handler.dropClick(slot, 1);
            }
        } else if (action == ClickType.QUICK_MOVE) {
            if (button == 0) {
                handler.addClick(slot, 99);
            }
            if (button == 1) {
                handler.setClick(slot, 0);
            }
        } else if (action == ClickType.SWAP && 0 <= button && button < 9) {
            handler.setClick(slot, button + 1);
        }
    }

    default public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
    }

    default public int skillPattern(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
        return 0;
    }

    default public void preAttack(Player player, LivingEntity target, Skill skill) {
    }

    default public int getExtraReach(LivingEntity entity, Skill skill) {
        return 0;
    }

    default public int getDefend(LivingEntity entity, Skill skill) {
        return 0;
    }

    default public int onDrawPhase(Player player, Skill skill) {
        return 0;
    }
}

