/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api.skill;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.SkillExecutor;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class Skill {
    public final ItemStack stack;
    public final ISkill item;

    public Skill(ItemStack skill) {
        ISkill iSkill;
        this.stack = skill;
        Item item = skill.getItem();
        if (item instanceof ISkill) {
            ISkill iSkill2 = (ISkill)item;
            iSkill = iSkill2;
        } else {
            iSkill = ModItems.EMPTY_SKILL;
        }
        this.item = iSkill;
    }

    public boolean lockOn() {
        if (this.item.isActiveSkill()) {
            return false;
        }
        return this.item.lockOn();
    }

    public boolean isActiveSkill() {
        return this.item.isActiveSkill();
    }

    public List<SkillExecutor> data() {
        return SkillCards.SKILL_MAP.getOrDefault(this.stack.getItem(), List.of());
    }

    public boolean activeSkill(Player user, Skill skill) {
        return this.item.activeSkill(user, skill);
    }

    public boolean activeSkill(Player user, Skill skill, LivingEntity target) {
        return this.item.activeSkill(user, skill, target);
    }

    public int getCD() {
        Integer i = (Integer)this.stack.get(ModItems.CD);
        return i == null ? 0 : i;
    }

    public void setCD(int seconds) {
        this.stack.set(ModItems.CD, (Object)seconds);
    }

    public int getTag() {
        Integer i = (Integer)this.stack.get(ModItems.TAGS);
        return i == null ? 0 : i;
    }

    public void setTag(int value) {
        this.stack.set(ModItems.TAGS, (Object)value);
    }

    public int getMinSelect() {
        CompoundTag nbt = this.getNbt();
        if (!nbt.contains("minSelect")) {
            return -1;
        }
        return nbt.getInt("minSelect");
    }

    public void setMinSelect(int value) {
        CompoundTag nbt = this.getNbt();
        nbt.putInt("minSelect", value);
        this.setNbt(nbt);
    }

    public int getMaxSelect() {
        CompoundTag nbt = this.getNbt();
        if (!nbt.contains("maxSelect")) {
            return Integer.MAX_VALUE;
        }
        return nbt.getInt("maxSelect");
    }

    public void setMaxSelect(int value) {
        CompoundTag nbt = this.getNbt();
        nbt.putInt("maxSelect", value);
        this.setNbt(nbt);
    }

    public void setShouldSelect(int min, int max) {
        this.setMinSelect(min);
        this.setMaxSelect(max);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public Component toHoverableText() {
        return this.stack.getDisplayName();
    }

    public CompoundTag getNbt() {
        return ModTools.getOrCreateNbt(this.stack);
    }

    public void setNbt(CompoundTag nbt) {
        ModTools.setNbt(this.stack, nbt);
    }
}

