/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.network.QuickSwapPayload;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.Tags;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@EventBusSubscriber(value={Dist.CLIENT}, modid="dabaosword", bus=EventBusSubscriber.Bus.GAME)
public class ChangeSkillRender {
    private static final Minecraft client = Minecraft.getInstance();
    public static boolean isRendering = false;
    private static int screenWidth;
    private static int screenHeight;
    private static int centerX;
    private static int centerY;
    private static List<ItemStack> skills;

    @SubscribeEvent
    public static void onHudRender(RenderGuiEvent.Post event) {
        GuiGraphics drawContext = event.getGuiGraphics();
        LocalPlayer player = ChangeSkillRender.client.player;
        if (!isRendering || player == null) {
            return;
        }
        if (skills.isEmpty()) {
            skills = ModTools.trinketsWithSlots((LivingEntity)player, s -> s.is(Tags.SKILLS)).stream().map(p -> ((IDynamicStackHandler)p.getA()).getStackInSlot(((Integer)p.getB()).intValue())).toList();
        }
        if (skills.size() < 2) {
            ChangeSkillRender.close();
            ChangeSkillRender.client.mouseHandler.grabMouse();
            return;
        }
        Font textRenderer = ChangeSkillRender.client.font;
        screenWidth = client.getWindow().getGuiScaledWidth();
        screenHeight = client.getWindow().getGuiScaledHeight();
        centerX = screenWidth / 2;
        centerY = screenHeight / 2;
        int radius = 80;
        int n = skills.size();
        for (int i = 0; i < n; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)n - 1.5707963267948966);
            int x = centerX + (int)((double)radius * Math.cos(angle));
            int y = centerY + (int)((double)radius * Math.sin(angle));
            ItemStack skill = skills.get(i);
            FormattedCharSequence text = skill.getDisplayName().getVisualOrderText();
            drawContext.renderItem(skill, x - 8, y - 16);
            drawContext.drawString(textRenderer, text, x - textRenderer.width(text) / 2, y, 0xFFFFFF, false);
        }
    }

    public static void close() {
        isRendering = false;
        skills = new ArrayList<ItemStack>();
    }

    public static void handleSkillSelect(double x, double y) {
        int parts;
        double partAngle;
        if (!isRendering) {
            return;
        }
        double angleDegrees = ChangeSkillRender.getAngleDegrees(x, y);
        double fixedDegree = angleDegrees + (partAngle = 360.0 / (double)(parts = skills.size())) / 2.0;
        if (fixedDegree >= 360.0) {
            fixedDegree -= 360.0;
        }
        int part = (int)(fixedDegree / partAngle);
        ChangeSkillRender.close();
        if (part <= 0) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new QuickSwapPayload(part + 100), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static double getAngleDegrees(double x, double y) {
        double e;
        double offsetY;
        Window clientWindow = client.getWindow();
        double d = x * (double)screenWidth / (double)clientWindow.getWidth();
        double offsetX = d - (double)centerX;
        double angleRadians = Math.atan2(offsetX, offsetY = (double)centerY - (e = y * (double)screenHeight / (double)clientWindow.getHeight()));
        double angleDegrees = Math.toDegrees(angleRadians);
        if (angleDegrees < 0.0) {
            angleDegrees += 360.0;
        }
        return angleDegrees;
    }

    static {
        skills = new ArrayList<ItemStack>();
    }
}

