/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.entity.ModEntity;
import com.amotassic.dabaosword.entity.client.ModModelLayers;
import com.amotassic.dabaosword.entity.client.XuyouModel;
import com.amotassic.dabaosword.entity.client.XuyouRenderer;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.ui.FullInvHandledScreen;
import com.amotassic.dabaosword.ui.PileHandledScreen;
import com.amotassic.dabaosword.ui.PlayerInvHandledScreen;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@EventBusSubscriber(modid="dabaosword", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class DabaoSwordClient {
    public static final KeyMapping ACTIVE_SKILL = new KeyMapping("key.dabaosword.active_skill", 74, "category.dabaosword.keybindings");
    public static final KeyMapping SELECT_CARD = new KeyMapping("key.dabaosword.select_card", 75, "category.dabaosword.keybindings");

    @SubscribeEvent
    public static void registerKeyBinds(RegisterKeyMappingsEvent event) {
        event.register(ACTIVE_SKILL);
        event.register(SELECT_CARD);
        DabaoSwordClient.registerPredicates();
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(ModItems.PLAYER_INV_SCREEN_HANDLER, PlayerInvHandledScreen::new);
        event.register(ModItems.FULL_INV_SCREEN_HANDLER, FullInvHandledScreen::new);
        event.register(ModItems.PILE_SCREEN_HANDLER, PileHandledScreen::new);
    }

    @SubscribeEvent
    public static void registerModel(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.XUYOU, XuyouModel::getTexturedModelData);
    }

    @SubscribeEvent
    public static void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntity.XUYOU, XuyouRenderer::new);
    }

    private static void registerPredicates() {
        List<Item> itemList = BuiltInRegistries.ITEM.stream().filter(item -> item instanceof CardItem).toList();
        for (Item item2 : itemList) {
            DabaoSwordClient.registerCustomModelPredicate(item2);
        }
    }

    private static void registerCustomModelPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)(item.toString() + "_sr")), (stack, clientWorld, livingEntity, seed) -> {
            Card card = ModTools.c(stack);
            Suit s = card.suit;
            Rank r = card.rank;
            if (s != Suit.None && r != Rank.None) {
                int suit = s.ordinal();
                int rank = r.ordinal() + 1;
                return (float)(0.13 * (double)suit + 0.01 * (double)rank);
            }
            return 0.0f;
        });
    }
}

