/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.command;

import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.ModTools;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class DabaoSwordCommand {
    private static final MutableComponent info = Component.translatable((String)"dabaosword.help.info").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/dabaosword info ")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.help.info_hover"))));
    private static final MutableComponent newGame = Component.translatable((String)"dabaosword.newgame").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword 2")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.newgame_hover"))));
    private static final MutableComponent viewId = Component.translatable((String)"dabaosword.viewid").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/dabaosword viewidentity @s")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.viewid_hover"))));
    private static final MutableComponent disGame = Component.translatable((String)"dabaosword.disgame").withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/dabaosword discardgame ")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.disgame_hover"))));
    public static final MutableComponent menu = info.append((Component)newGame).append((Component)viewId).append((Component)disGame);

    public static void registerCommands(RegisterCommandsEvent evt) {
        DabaoSwordCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dabaosword").requires(source -> source.getEntity() != null)).executes(c -> DabaoSwordCommand.help((CommandSourceStack)c.getSource(), 0))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(c -> DabaoSwordCommand.help((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"page"))))).then(Commands.argument((String)"user", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"skill", (ArgumentType)ItemArgument.item((CommandBuildContext)access)).executes(c -> DabaoSwordCommand.skill((Player)EntityArgument.getPlayer((CommandContext)c, (String)"user"), ItemArgument.getItem((CommandContext)c, (String)"skill"), (LivingEntity)EntityArgument.getPlayer((CommandContext)c, (String)"user"), new int[0]))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(c -> DabaoSwordCommand.skill((Player)EntityArgument.getPlayer((CommandContext)c, (String)"user"), ItemArgument.getItem((CommandContext)c, (String)"skill"), (LivingEntity)EntityArgument.getEntity((CommandContext)c, (String)"target"), new int[0]))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(c -> DabaoSwordCommand.skill((Player)EntityArgument.getPlayer((CommandContext)c, (String)"user"), ItemArgument.getItem((CommandContext)c, (String)"skill"), (LivingEntity)EntityArgument.getEntity((CommandContext)c, (String)"target"), IntegerArgumentType.getInteger((CommandContext)c, (String)"value")))))))).then(Commands.literal((String)"creategame").then(Commands.argument((String)"type", (ArgumentType)IntegerArgumentType.integer()).executes(c -> DabaoSwordCommand.createGame((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"type")))))).then(Commands.literal((String)"refusegame").executes(DabaoSwordCommand::refuseGame))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"discardgame").requires(source -> source.hasPermission(2))).executes(c -> DabaoSwordCommand.discardGame((CommandContext<CommandSourceStack>)c, null))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> DabaoSwordCommand.discardGame((CommandContext<CommandSourceStack>)c, EntityArgument.getPlayer((CommandContext)c, (String)"player")))))).then(Commands.literal((String)"viewidentity").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(c -> DabaoSwordCommand.viewIdentity((CommandSourceStack)c.getSource(), EntityArgument.getPlayer((CommandContext)c, (String)"target")))))).then(Commands.literal((String)"info").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(c -> DabaoSwordCommand.info((CommandContext<CommandSourceStack>)c, EntityArgument.getEntity((CommandContext)c, (String)"target"), false))).then(((RequiredArgumentBuilder)Commands.argument((String)"editable", (ArgumentType)BoolArgumentType.bool()).requires(source -> source.hasPermission(2))).executes(c -> DabaoSwordCommand.info((CommandContext<CommandSourceStack>)c, EntityArgument.getEntity((CommandContext)c, (String)"target"), BoolArgumentType.getBool((CommandContext)c, (String)"editable")))))));
    }

    private static int info(CommandContext<CommandSourceStack> context, Entity entity, boolean editable) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            ModTools.openFullInv((Player)player, target, editable);
            return 1;
        }
        player.displayClientMessage((Component)Component.translatable((String)"info.fail").withStyle(ChatFormatting.RED), false);
        return 0;
    }

    private static int skill(Player user, ItemInput stack, LivingEntity target, int ... value) {
        int val = value.length == 0 ? 0 : value[0];
        ItemStack skill = ModTools.trinketItem(stack.getItem(), (LivingEntity)user);
        Item item = skill.getItem();
        if (item instanceof CSkill) {
            CSkill s = (CSkill)item;
            s.triggerSkill((LivingEntity)user, ModTools.s(skill), target, val);
        }
        return 1;
    }

    private static int createGame(CommandSourceStack ctx, int type) throws CommandSyntaxException {
        ServerPlayer player = ctx.getPlayerOrException();
        Game game = PVPGameEvents.getGameManager().createGame(player, type);
        if (game == null) {
            return 0;
        }
        return 1;
    }

    private static int refuseGame(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Game game = PVPGameEvents.getGameManager().getGameByPlayer((Player)player);
        if (game == null) {
            return 0;
        }
        if (!game.isWaiting()) {
            return 0;
        }
        game.refuseGame((Player)player);
        return 1;
    }

    private static int discardGame(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        Game game;
        if (player == null) {
            player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        }
        if ((game = PVPGameEvents.getGameManager().getGameByPlayer((Player)player)) == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"dabaosword.game.not_found", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.RED));
            return 0;
        }
        game.discardGame();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Game discarded!"), false);
        return 1;
    }

    private static int viewIdentity(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        Game game = PVPGameEvents.getGameManager().getGameByPlayer((Player)target);
        if (game == null) {
            source.sendFailure((Component)Component.translatable((String)"dabaosword.game.not_found", (Object[])new Object[]{target.getDisplayName()}).withStyle(ChatFormatting.RED));
            return 0;
        }
        Game.Identity id = game.getIdentity(target);
        if (player == target) {
            DabaoSwordCommand.feedbackIdentity(source, target, id);
            return 1;
        }
        if (player.hasPermissions(2)) {
            DabaoSwordCommand.feedbackIdentity(source, target, id);
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"dabaosword.game.view_id.fail").withStyle(ChatFormatting.RED));
        return 0;
    }

    private static void feedbackIdentity(CommandSourceStack source, ServerPlayer target, Game.Identity identity) {
        source.sendSuccess(() -> Component.translatable((String)"dabaosword.game.view_id.tip", (Object[])new Object[]{target.getDisplayName(), Component.translatable((String)identity.tag)}).withStyle(Game.getIdentityColor(identity)), false);
    }

    private static int help(CommandSourceStack source, int page) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        switch (page) {
            case 0: {
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.welcome"), false);
                MutableComponent text = Component.translatable((String)"dabaosword.mainpage").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/mod/dabaosword")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Modrinth")))).append((Component)Component.translatable((String)"dabaosword.help.menu").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword 1")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.help.menu_hover")))));
                player.displayClientMessage((Component)text, false);
                break;
            }
            case 1: {
                player.displayClientMessage((Component)menu, false);
                break;
            }
            case 2: {
                MutableComponent text = Component.translatable((String)"dabaosword.rule").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword 3"))).append((Component)Component.translatable((String)"dabaosword.newgame0").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword creategame 0")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.newgame0_hover"))))).append((Component)Component.translatable((String)"dabaosword.newgame1").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword creategame 1")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.newgame1_hover")))));
                player.displayClientMessage((Component)text, false);
                break;
            }
            case 3: {
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.rule1"), false);
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.rule2"), false);
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.rule3"), false);
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.rule4"), false);
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.rule5"), false);
            }
        }
        return 1;
    }

    public static interface CSkill {
        public void triggerSkill(LivingEntity var1, Skill var2, LivingEntity var3, int var4);
    }
}

