/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.effect;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.tool.ArrowRainItem;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Cooldown2Effect
extends MobEffect {
    public Cooldown2Effect() {
        super(MobEffectCategory.NEUTRAL, 0xFFFFFF);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            int restTime = Objects.requireNonNull(entity.getEffect(ModItems.COOLDOWN2)).getDuration();
            if (amplifier == 3 && restTime % 2 == 0) {
                EntityType.LIGHTNING_BOLT.spawn(world, new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ()), MobSpawnType.MOB_SUMMONED);
            }
            if (amplifier == 1 && restTime % 3 == 0) {
                ArrowRainItem.arrowAround(entity, 3.0f, 18, 10.0, 3.0);
                ArrowRainItem.arrowAround(entity, 3.0f, 18, 8.0, 4.0);
                ArrowRainItem.arrowAround(entity, 3.0f, 18, 6.0, 5.0);
                ArrowRainItem.arrowAround(entity, 3.0f, 18, 4.0, 6.0);
                ArrowRainItem.arrowAround(entity, 3.0f, 18, 2.0, 7.0);
            }
            if (amplifier == 5 && restTime % 4 == 0) {
                ArrowRainItem.tridentStorm(entity, 3.0f, 18, 10.0, 3.0);
                ArrowRainItem.tridentStorm(entity, 3.0f, 18, 8.0, 4.0);
                ArrowRainItem.tridentStorm(entity, 3.0f, 18, 6.0, 5.0);
                ArrowRainItem.tridentStorm(entity, 3.0f, 18, 4.0, 6.0);
                ArrowRainItem.tridentStorm(entity, 3.0f, 18, 2.0, 7.0);
            }
        }
        return true;
    }
}

