/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.effect;

import com.amotassic.dabaosword.item.ModItems;
import java.util.Objects;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ShandianEffect
extends MobEffect {
    public ShandianEffect() {
        super(MobEffectCategory.HARMFUL, 0);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        int restTime;
        if (entity.level() instanceof ServerLevel && ((restTime = Objects.requireNonNull(entity.getEffect(ModItems.SHANDIAN)).getDuration()) % 100 == 0 || restTime <= 1)) {
            Random random = new Random();
            if (random.nextDouble() < 0.15384615384615385) {
                ShandianEffect.summonLightning(entity, false, true);
            }
        }
        return true;
    }

    public static void summonLightning(LivingEntity entity, boolean cosmetic, boolean tag) {
        ServerLevel world;
        LightningBolt lightning;
        Level level = entity.level();
        if (level instanceof ServerLevel && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)(world = (ServerLevel)level))) != null) {
            lightning.moveTo(entity.getX(), entity.getY(), entity.getZ());
            if (cosmetic) {
                lightning.setVisualOnly(true);
            }
            if (tag) {
                lightning.addTag("a");
            }
            world.addFreshEntity((Entity)lightning);
        }
    }
}

