/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.entity;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UseCardGoal
extends Goal {
    private final Mob mob;

    public UseCardGoal(Mob mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        return !this.getCards().isEmpty();
    }

    private List<ItemStack> getCards() {
        ArrayList<ItemStack> cards = new ArrayList<ItemStack>();
        ItemStack main = this.mob.getMainHandItem();
        ItemStack off = this.mob.getOffhandItem();
        if (ModTools.isCard(main)) {
            cards.add(main);
        }
        if (ModTools.isCard(off)) {
            cards.add(off);
        }
        return cards;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.mob.level().getGameTime() % 20L != 0L) {
            return;
        }
        for (ItemStack card : this.getCards()) {
            LivingEntity target;
            if (ModTools.isEquipment.test(card)) {
                CardItem.onUse((LivingEntity)this.mob, card, null, new LivingEntity[]{this.mob});
            }
            if (ModTools.isSha.test(card) || card.is((Item)ModItems.SHAN) || card.is((Item)ModItems.WUXIE)) continue;
            if (card.is((Item)ModItems.WUGU) || card.is((Item)ModItems.TAOYUAN)) {
                card.setCount(0);
            }
            if (card.is((Item)ModItems.PEACH)) {
                if (this.mob.getHealth() > this.mob.getMaxHealth() - 5.0f) continue;
                CardItem.onUse((LivingEntity)this.mob, card, null, new LivingEntity[]{this.mob});
            }
            if (card.is((Item)ModItems.JIU)) {
                if (this.mob.hasEffect(MobEffects.DAMAGE_BOOST)) continue;
                CardItem.onUse((LivingEntity)this.mob, card, null, new LivingEntity[]{this.mob});
            }
            if (card.is((Item)ModItems.WUZHONG)) {
                CardItem.onUse((LivingEntity)this.mob, card, null, new LivingEntity[]{this.mob});
            }
            if ((target = this.mob.getTarget()) == null) continue;
            if (card.is((Item)ModItems.FIRE_ATTACK) || card.is((Item)ModItems.WANJIAN)) {
                this.mob.getLookControl().setLookAt((Entity)target);
                CardItem.onUse((LivingEntity)this.mob, card, null, new LivingEntity[]{this.mob});
            }
            if (!ModTools.c(card).askForWuxie() || this.mob.distanceTo((Entity)target) > 5.0f) continue;
            CardItem.onUse((LivingEntity)this.mob, card, null, target);
        }
    }
}

