/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.entity;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.entity.UseCardGoal;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XuyouEntity
extends Monster
implements RangedAttackMob {
    public static final EntityType<XuyouEntity> TYPE = EntityType.Builder.of(XuyouEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.8f).build("xuyou");
    private int bbcd = 0;
    private int bbTimes = 0;
    private final RangedAttackGoal bb = new RangedAttackGoal((RangedAttackMob)this, 1.25, 10, 7.0f);

    protected XuyouEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public XuyouEntity(Level level) {
        this(TYPE, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new UseCardGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("bbcd", this.bbcd);
        nbt.putInt("bbTimes", this.bbTimes);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.bbcd = nbt.getInt("bbcd");
        this.bbTimes = nbt.getInt("bbTimes");
    }

    protected void customServerAiStep() {
        if (this.level().getGameTime() % 200L == 0L) {
            ModTools.draw((LivingEntity)this, new int[0]);
        }
        if (this.bbTimes >= 5) {
            this.goalSelector.removeGoal((Goal)this.bb);
            this.bbTimes = 0;
            this.bbcd = 150;
        }
        if (this.bbcd > 0) {
            --this.bbcd;
        } else {
            this.goalSelector.addGoal(2, (Goal)this.bb);
        }
    }

    public boolean canAttack(LivingEntity target) {
        if (target.distanceTo((Entity)this) > 10.0f) {
            return false;
        }
        return super.canAttack(target);
    }

    protected SoundEvent getDeathSound() {
        return ModTools.getSound("dabaosword", "xuyou");
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        if (source.is(ModDT.LOSEHP)) {
            return ModTools.getSound("dabaosword", "losehp");
        }
        return source.type().effects().sound();
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (this.level().isClientSide) {
            return;
        }
        ExData data = ModTools.d();
        for (ItemStack stack : ModTools.allTrinkets((LivingEntity)this)) {
            if (!ModTools.isCard(stack)) continue;
            data.cards(stack, stack.getCount(), true);
        }
        CardEvents.cardDiscard((LivingEntity)this, data);
    }

    public void performRangedAttack(@NotNull LivingEntity target, float v) {
        ++this.bbTimes;
        target.invulnerableTime = 0;
        target.hurt(ModDT.bbll((Entity)this), 2.0f);
        ModTools.voice((LivingEntity)this, "bbji", new float[0]);
    }
}

