/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.effect.ShandianEffect;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.Tags;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="dabaosword", bus=EventBusSubscriber.Bus.GAME)
public class EntityHurtHandler {
    private static void trySave(LivingEntity entity, float amount) {
        for (int i = 0; i < 114; ++i) {
            if (entity.isAlive()) {
                return;
            }
            ItemStack stack = ModTools.getCard(entity, ModTools.canSaveDying);
            if (stack.isEmpty()) continue;
            CardItem.onUse(entity, stack, null, true, new LivingEntity[0]);
            entity.setHealth(entity.getHealth() - amount + 5.0f);
            amount -= 5.0f;
        }
    }

    private static void tiesuoTrigger(LivingEntity entity, DamageSource source, float amount) {
        Level world = entity.level();
        if (entity.isCurrentlyGlowing() && source.is(Tags.TRIGGER_TIESUO)) {
            entity.removeEffect(MobEffects.GLOWING);
            AABB box = new AABB(entity.getOnPos()).inflate(20.0);
            for (LivingEntity near : world.getEntitiesOfClass(LivingEntity.class, box, e -> e != entity && e.isCurrentlyGlowing())) {
                near.removeEffect(MobEffects.GLOWING);
                near.hurt(source, amount);
                if (source.is(DamageTypeTags.IS_FREEZING)) {
                    near.setTicksFrozen(entity.getTicksFrozen());
                }
                if (source.is(DamageTypeTags.IS_FIRE)) {
                    int fireTicks = entity.getRemainingFireTicks() / 20;
                    int fireTime = fireTicks == 0 ? 6 : fireTicks;
                    near.setRemainingFireTicks(fireTime * 20);
                }
                if (!source.is(DamageTypeTags.IS_LIGHTNING)) continue;
                ShandianEffect.summonLightning(near, true, false);
            }
        }
    }

    @SubscribeEvent
    public static void EntityHurt(LivingDamageEvent.Post event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getNewDamage();
        if (entity.level() instanceof ServerLevel) {
            Entity entity2;
            EntityHurtHandler.tiesuoTrigger(entity, source, amount);
            ModTools.getSkillOwners(entity).forEach(player -> ModTools.getResult(Trigger.ON_HURT, player, entity, ModTools.d().withDamage(source, Float.valueOf(amount))));
            EntityHurtHandler.trySave(entity, amount);
            if (source.is(Tags.FROM_CARD)) {
                CardEvents.hurtByCard(entity, source, amount);
            }
            if ((entity2 = source.getEntity()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                if (living.getTags().contains("px")) {
                    entity.invulnerableTime = 0;
                }
                if (living instanceof Player && entity instanceof Player && amount >= 15.0f) {
                    ModTools.voice(living, "wushuang", new float[0]);
                }
            }
            if ((entity2 = source.getEntity()) instanceof Player) {
                Player player2 = (Player)entity2;
                if (entity.getHealth() <= 0.0f) {
                    if (entity instanceof Monster) {
                        Random random = new Random();
                        if ((double)random.nextFloat() < 0.1) {
                            ModTools.draw((LivingEntity)player2, new int[0]);
                            player2.displayClientMessage((Component)Component.translatable((String)"dabaosword.draw.monster"), true);
                        }
                    }
                    if (entity instanceof Player) {
                        if (player2.getHealth() < 20.0f) {
                            player2.heal(20.0f - player2.getHealth());
                        }
                        ModTools.draw((LivingEntity)player2, new int[0]);
                        player2.displayClientMessage((Component)Component.translatable((String)"dabaosword.draw.player"), true);
                    }
                }
            }
            if (entity.isDeadOrDying()) {
                ModTools.getSkillOwners(entity).forEach(player -> ModTools.getResult(Trigger.ON_DEATH, player, entity, ModTools.d().withDamage(source, Float.valueOf(amount))));
            }
        }
    }
}

