/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.ModTools;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@EventBusSubscriber(modid="dabaosword", bus=EventBusSubscriber.Bus.GAME)
public class EntityTickEvents {
    @SubscribeEvent
    public static void endLivingTick(EntityTickEvent.Post event) {
        Entity en = event.getEntity();
        Level level = en.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (en instanceof LivingEntity) {
                ItemStack stack;
                Player closest;
                LivingEntity entity = (LivingEntity)en;
                long time = world.getGameTime();
                if (time % 2L == 0L) {
                    String[] tags = new String[]{"sha", "juedou", "nanman", "wanjian"};
                    for (String tag : tags) {
                        entity.getTags().remove(tag);
                    }
                }
                if (time % 20L == 0L && entity.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.SUNSHINE_SMILE)) {
                    for (LivingEntity e2 : world.getEntitiesOfClass(LivingEntity.class, new AABB(entity.getOnPos()).inflate(20.0), e -> e != entity && EntityTickEvents.isEyeContact((Entity)e, (Entity)entity, 25.0f))) {
                        e2.setTicksFrozen(240);
                    }
                }
                if (time % 200L == 0L) {
                    entity.getTags().remove("seen_skill_tip");
                }
                int level1 = 0;
                int level2 = 0;
                if (ModTools.shouldReachLong(entity)) {
                    level1 += 114;
                }
                for (Skill skill : ModTools.getSkillsMayUse(entity)) {
                    level1 += skill.item.getExtraReach(entity, skill);
                    level2 += skill.item.getDefend(entity, skill);
                }
                if (level1 > 0) {
                    entity.addEffect(new MobEffectInstance(ModItems.REACH, 2, level1 - 1, false, false, false));
                }
                if (level2 > 0) {
                    entity.addEffect(new MobEffectInstance(ModItems.DEFEND, 2, level2 - 1, false, false, false));
                }
                if ((closest = world.getNearestPlayer((Entity)entity, 5.0)) != null && !(stack = ModTools.trinketItem(ModItems.FANGTIAN, (LivingEntity)closest)).isEmpty() && entity.isAlive() && ModTools.s(stack).getCD() > 15 && closest.swingTime == 1) {
                    closest.addEffect(new MobEffectInstance(ModItems.INVULNERABLE, 2, 0, false, false, false));
                    float i = (float)closest.getAttributeValue(Attributes.ATTACK_DAMAGE);
                    entity.hurt(closest.damageSources().playerAttack(closest), i);
                }
            }
        }
    }

    @SubscribeEvent
    public static void endPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level instanceof ServerLevel) {
            Set tags;
            ServerLevel world = (ServerLevel)level;
            long time = world.getGameTime();
            int giveCard = Math.max(20, world.getGameRules().getInt(Gamerule.GIVE_CARD_INTERVAL) * 20);
            boolean limit = world.getGameRules().getBoolean(Gamerule.ENABLE_CARDS_LIMIT);
            if (time % 100L == 0L && !PVPGameEvents.getGameManager().isPlayerInGame(player) && ((tags = player.getTags()).contains("dabaosword.zhong") || tags.contains("dabaosword.fan") || tags.contains("dabaosword.nei"))) {
                player.getTags().remove("dabaosword.zhong");
                player.getTags().remove("dabaosword.fan");
                player.getTags().remove("dabaosword.nei");
                if (player.isSpectator()) {
                    ((ServerPlayer)player).setGameMode(GameType.SURVIVAL);
                    player.kill();
                }
            }
            if (time % (long)giveCard == 0L && !player.isCreative() && !player.isSpectator() && player.isAlive()) {
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.draw"), true);
                if (player.hasEffect(ModItems.BINGLIANG)) {
                    player.removeEffect(ModItems.BINGLIANG);
                } else if ((float)ModTools.countCards((LivingEntity)player) < player.getMaxHealth() || !limit) {
                    int draw = ModTools.hasTrinket(ModItems.CARD_PILE, (LivingEntity)player) ? 2 : 0;
                    for (Skill skill : ModTools.getSkillsMayUse((LivingEntity)player)) {
                        int i = skill.item.onDrawPhase(player, skill);
                        if (i <= -114) {
                            draw = 0;
                            break;
                        }
                        draw += i;
                    }
                    if (draw > 0) {
                        ModTools.draw((LivingEntity)player, draw);
                    }
                }
            }
            if (time % 2L == 0L) {
                EntityTickEvents.decreaseAttackRange((LivingEntity)player);
            }
            if (player.containerMenu != player.inventoryMenu && time % 3L == 0L) {
                for (Skill skill : CuriosApi.getCuriosInventory((LivingEntity)player).map(c -> c.findCurios(s -> s.getItem() instanceof ISkill).stream().map(SlotResult::stack).map(Skill::new).toList()).orElse(Collections.emptyList())) {
                    ISkill s = skill.item;
                    if (!s.shouldTickUpdate()) continue;
                    s.tickUpdateNbt(skill, (LivingEntity)player);
                }
            }
        }
    }

    private static void decreaseAttackRange(LivingEntity entity) {
        AABB box = new AABB(entity.getOnPos()).inflate(20.0);
        for (LivingEntity target : entity.level().getEntitiesOfClass(LivingEntity.class, box, living -> living != entity && living.hasEffect(ModItems.DEFEND) && EntityTickEvents.isLooking(entity, (Entity)living))) {
            int amplifier = Objects.requireNonNull(target.getEffect(ModItems.DEFEND)).getAmplifier();
            entity.addEffect(new MobEffectInstance(ModItems.DEFENDED, 2, amplifier, false, false, true));
        }
    }

    public static boolean isLooking(LivingEntity entity, Entity target) {
        Vec3 playerPos = entity.getEyePosition();
        Vec3 lookVec = entity.getViewVector(1.0f);
        AABB targetBox = target.getBoundingBox();
        return targetBox.clip(playerPos, playerPos.add(lookVec.scale(100.0))).isPresent();
    }

    public static boolean isEyeContact(Entity entity1, Entity entity2, float angle) {
        double MAX_ANGLE = Math.toRadians(angle);
        Vec3 pos1 = entity1.position();
        Vec3 pos2 = entity2.position();
        Vec3 d = pos2.subtract(pos1);
        Vec3 v1 = entity1.getViewVector(1.0f);
        Vec3 v2 = entity2.getViewVector(1.0f);
        double theta1 = Math.acos(v1.dot(d.normalize()));
        double theta2 = Math.acos(v2.dot(d.normalize().reverse()));
        return theta1 <= MAX_ANGLE && theta2 <= MAX_ANGLE;
    }
}

