/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.event.PVPGameTickEvent;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.pvpgame.GameManager;
import com.amotassic.dabaosword.util.ModTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="dabaosword", bus=EventBusSubscriber.Bus.GAME)
public class PVPGameEvents {
    private static GameManager gameManager;
    public static final Map<ServerPlayer, CardPileInventory> PLAYER_CARD_PACKS;

    public static GameManager getGameManager() {
        return gameManager;
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel world;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (world = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            gameManager = (GameManager)world.getDataStorage().computeIfAbsent(GameManager.factory(world), "dabaosword_game");
        }
    }

    @SubscribeEvent
    public static void onStartTick(LevelTickEvent.Post event) {
        ServerLevel world;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (world = (ServerLevel)level).dimension() == Level.OVERWORLD) {
            gameManager.tick();
        }
    }

    @SubscribeEvent
    public static void onGameTick(PVPGameTickEvent event) {
        Game game = event.getGame();
        ServerLevel world = event.getLevel();
        int countDown = game.getCountDown();
        if (game.isWaiting()) {
            PVPGameEvents.countDownTip(game, countDown);
        }
        if (countDown == 0) {
            PVPGameEvents.onGameStart(game, world);
        }
        if (game.isOn()) {
            PVPGameEvents.handleTimeOut(game, game.getTimeOut());
        }
        if (game.neiLives <= 0) {
            if (game.fanLives <= 0) {
                game.win(Game.Identity.ZHONG);
            }
            if (game.zhongLives <= 0) {
                game.win(Game.Identity.FAN);
            }
        } else {
            if (game.fanLives <= 0) {
                PVPGameEvents.twoTeam(game, Game.Identity.ZHONG);
                if (game.zhongLives <= 0) {
                    game.win(Game.Identity.NEI);
                }
            }
            if (game.zhongLives <= 0) {
                PVPGameEvents.twoTeam(game, Game.Identity.FAN);
            }
        }
    }

    public static void onGameCreate(ServerPlayer player, Game game, Set<UUID> players) {
        MutableComponent text = Component.translatable((String)"dabaosword.game.create", (Object[])new Object[]{player.getDisplayName(), players.size()});
        if (game.getPrimaryData().get("neiCount") == 0) {
            text = text.append((Component)Component.translatable((String)"dabaosword.game.no_turn_coat"));
        }
        MutableComponent finalText = text;
        game.forEachPlayer(p -> p.displayClientMessage((Component)finalText, false));
    }

    private static void countDownTip(Game game, int countDown) {
        if (countDown % 20 != 0) {
            return;
        }
        game.forEachPlayer(player -> {
            if (countDown % 100 == 0) {
                MutableComponent quit = Component.translatable((String)"dabaosword.refuse").withStyle(ChatFormatting.RED).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword refusegame")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"dabaosword.refuse_hover"))));
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.game.wait", (Object[])new Object[]{countDown / 20}).append((Component)quit), false);
                return;
            }
            Set<Integer> times = Set.of(Integer.valueOf(60), Integer.valueOf(40), Integer.valueOf(20));
            if (times.contains(countDown)) {
                ModTools.voice((LivingEntity)player, (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), new float[0]);
                ModTools.title(player, (Component)Component.literal((String)String.valueOf(countDown / 20)));
            }
        });
    }

    private static void onGameStart(Game game, ServerLevel world) {
        ServerScoreboard scoreboard = world.getServer().getScoreboard();
        Objective obj = scoreboard.getObjectives().stream().filter(o -> o.getName().equals("dabaosword.death")).findFirst().orElse(null);
        ObjectiveCriteria criterion = ObjectiveCriteria.DEATH_COUNT;
        if (obj == null) {
            obj = scoreboard.addObjective("dabaosword.death", criterion, (Component)Component.translatable((String)"dabaosword.score.death"), criterion.getDefaultRenderType(), false, null);
        }
        scoreboard.setDisplayObjective(DisplaySlot.SIDEBAR, obj);
        game.forEachPlayer(player -> {
            Game.Identity identity = game.getIdentity((ServerPlayer)player);
            ChatFormatting color = Game.getIdentityColor(identity);
            MutableComponent o1 = Component.translatable((String)identity.tag);
            MutableComponent o2 = Component.translatable((String)(identity.tag + ".tip"));
            MutableComponent o3 = Component.translatable((String)"dabaosword.game.start.tip", (Object[])new Object[]{o1, o2}).withStyle(color);
            ModTools.title(player, (Component)Component.translatable((String)"dabaosword.game.start").withStyle(ChatFormatting.GOLD));
            ModTools.subtitle(player, (Component)o3);
            player.displayClientMessage((Component)o3, false);
            ModTools.voice((LivingEntity)player, (SoundEvent)SoundEvents.RAID_HORN.value(), 32.0f);
        });
    }

    private static void handleTimeOut(Game game, int timeOut) {
        if (game.getGameTime() % 20 != 0) {
            return;
        }
        if (timeOut == 60 || timeOut == 30) {
            game.forEachPlayer(player -> player.displayClientMessage((Component)Component.translatable((String)"dabaosword.game.timeout.warn", (Object[])new Object[]{timeOut}).withStyle(ChatFormatting.YELLOW), false));
        }
        if (timeOut == 0) {
            game.timeOut();
        }
    }

    private static void twoTeam(Game game, Game.Identity identity) {
        Game.Identity nei = Game.Identity.NEI;
        if (identity == nei) {
            return;
        }
        if (game.getScore(identity) > game.neiScore) {
            game.win(identity);
        }
        if (game.getScore(identity) < game.neiScore) {
            game.win(nei);
        }
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Pre event) {
        DabaoSword.server = event.getServer();
        List playerList = event.getServer().getPlayerList().getPlayers();
        for (ServerPlayer player2 : playerList) {
            if (PLAYER_CARD_PACKS.containsKey(player2) || !ModTools.hasTrinket(ModItems.CARD_PILE, (LivingEntity)player2)) continue;
            PLAYER_CARD_PACKS.put(player2, new CardPileInventory((Player)player2));
        }
        PLAYER_CARD_PACKS.keySet().removeIf(player -> player == null || player.isRemoved() || !ModTools.hasTrinket(ModItems.CARD_PILE, (LivingEntity)player));
    }

    static {
        PLAYER_CARD_PACKS = new HashMap<ServerPlayer, CardPileInventory>();
    }
}

