/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.MODConfig;
import com.amotassic.dabaosword.util.ModTools;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="dabaosword", bus=EventBusSubscriber.Bus.GAME)
public class PlayerEvents {
    private static final Map<UUID, KillStreakData> playerKillData = new HashMap<UUID, KillStreakData>();

    private static String getKillSound(int streak) {
        return switch (streak) {
            case 1, 2, 3, 4, 5, 6, 7 -> "kill" + streak;
            default -> "diankuang";
        };
    }

    @SubscribeEvent
    public static void PlayerDie(LivingDeathEvent event) {
        Player player;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).level()) instanceof ServerLevel) {
            Game game;
            ServerPlayer killer;
            ServerLevel world = (ServerLevel)livingEntity;
            Entity attacker = source.getEntity();
            if (!(attacker instanceof Player)) {
                attacker = player.getKillCredit();
            }
            if (MODConfig.KillStreak && attacker instanceof ServerPlayer) {
                KillStreakData data;
                killer = (ServerPlayer)attacker;
                UUID id = killer.getUUID();
                long time = world.getGameTime();
                long timeDiff = time - (data = playerKillData.getOrDefault(id, new KillStreakData(0, 0L))).lastKillTime();
                int newStreak = 0L <= timeDiff && timeDiff <= 1200L ? data.streak() + 1 : 1;
                data = new KillStreakData(newStreak, time);
                playerKillData.put(id, data);
                if (data.streak() >= 2) {
                    ModTools.voice((LivingEntity)killer, PlayerEvents.getKillSound(data.streak()), new float[0]);
                }
            }
            if (attacker instanceof ServerPlayer) {
                Game game2;
                ServerPlayer dead;
                killer = (ServerPlayer)attacker;
                if (player instanceof ServerPlayer && killer != (dead = (ServerPlayer)player) && (game2 = PVPGameEvents.getGameManager().getGameByPlayer((Player)killer)) != null && game2.isOn() && game2.isPlayerInThisGame((Player)dead)) {
                    Map<String, Integer> primaryData = game2.getPrimaryData();
                    if (MODConfig.KillStreak && game2.zhongLives + game2.fanLives + game2.neiLives == primaryData.get("zhongLives") + primaryData.get("fanLives") + primaryData.get("neiLives")) {
                        ModTools.voice((LivingEntity)killer, PlayerEvents.getKillSound(1), new float[0]);
                    }
                    Game.Identity killerTeam = game2.getIdentity(killer);
                    Game.Identity deadTeam = game2.getIdentity(dead);
                    if (deadTeam != Game.Identity.NEI && killerTeam != deadTeam) {
                        game2.increaseScore(killer);
                    }
                }
            }
            if ((game = PVPGameEvents.getGameManager().getGameByPlayer(player)) != null && game.isOn() && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                game.decreaseLives(sp);
                Game.Identity identity = game.getIdentity(sp);
                int re = game.getRespawnChances(identity);
                if (re <= 0) {
                    sp.setGameMode(GameType.SPECTATOR);
                    game.forEachPlayer(p -> p.displayClientMessage((Component)Component.translatable((String)"dabaosword.game.view_id.tip", (Object[])new Object[]{player.getDisplayName(), Component.translatable((String)identity.tag)}).withStyle(new ChatFormatting[]{Game.getIdentityColor(identity), ChatFormatting.BOLD}), false));
                }
            }
            if (world.getGameRules().getBoolean(Gamerule.CLEAR_CARDS_AFTER_DEATH)) {
                CardEvents.cardDiscard((LivingEntity)player, PlayerEvents.cardsToDrop(player));
            }
            if (ModTools.hasItem((LivingEntity)player, ModTools.p(ModItems.BBJI))) {
                ModTools.voice((LivingEntity)player, "xuyou", new float[0]);
            }
            player.getTags().remove("duanchang");
        }
    }

    public static ExData cardsToDrop(Player player) {
        ExData data = ModTools.d();
        CardPileInventory inventory = ModTools.getCardPack(player);
        for (ItemStack stack : inventory.cards) {
            data.cards(stack, stack.getCount(), new boolean[0]);
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!ModTools.isCard(stack)) continue;
            data.cards(stack, stack.getCount(), new boolean[0]);
        }
        for (ItemStack stack : ModTools.allTrinkets((LivingEntity)player)) {
            if (!ModTools.isCard(stack)) continue;
            data.cards(stack, stack.getCount(), true);
        }
        return data;
    }

    @SubscribeEvent
    public static void PlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerLevel world;
        boolean card;
        Player player = event.getEntity();
        Level level = player.level();
        if (level instanceof ServerLevel && (card = (world = (ServerLevel)level).getGameRules().getBoolean(Gamerule.CLEAR_CARDS_AFTER_DEATH)) && ModTools.hasTrinket(ModItems.CARD_PILE, (LivingEntity)player)) {
            ModTools.give((LivingEntity)player, ModTools.newCard(ModItems.SHA), new int[0]);
            ModTools.give((LivingEntity)player, ModTools.newCard(ModItems.SHAN), new int[0]);
            ModTools.give((LivingEntity)player, ModTools.newCard(ModItems.PEACH), new int[0]);
            ModTools.draw((LivingEntity)player, new int[0]);
        }
    }

    private record KillStreakData(int streak, long lastKillTime) {
    }
}

