/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item;

import com.amotassic.dabaosword.item.skillcard.SkillItem;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GiftBoxItem
extends Item {
    public GiftBoxItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.gift_box.tooltip").withStyle(ChatFormatting.GOLD));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getOffhandItem();
        if (!world.isClientSide && hand == InteractionHand.MAIN_HAND && !stack.isEmpty()) {
            float chance = 0.01f;
            if (stack.getItem() == Items.GOLD_INGOT) {
                stack.setCount(0);
                return this.giftBox(user, chance += 0.01f * (float)stack.getCount());
            }
            if (stack.getItem() == Items.GOLD_BLOCK) {
                stack.shrink(Math.min(stack.getCount(), 11));
                return this.giftBox(user, chance += 0.09f * (float)stack.getCount());
            }
        }
        return super.use(world, user, hand);
    }

    public InteractionResultHolder<ItemStack> giftBox(Player player, float chance) {
        Random random = new Random();
        if (random.nextFloat() < chance) {
            SkillItem.changeSkill(player);
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
            }
            return InteractionResultHolder.success((Object)player.getMainHandItem());
        }
        return InteractionResultHolder.pass((Object)player.getMainHandItem());
    }
}

