/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public abstract class CardItem
extends Item {
    public CardItem(Item.Properties settings) {
        super(settings);
    }

    public abstract int getType();

    public void effect(LivingEntity user, ItemStack card, LivingEntity target) {
    }

    public boolean rangedUse() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        this.addSRTip(ModTools.c(stack), tooltip);
        this.addTip(stack, tooltip);
    }

    public void addTip(ItemStack stack, List<Component> tooltip) {
        CardItem c;
        Item item;
        if (stack.is((Item)ModItems.SHAN)) {
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.shan.tip").withStyle(ChatFormatting.BOLD));
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }
        if (stack.is((Item)ModItems.PEACH)) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]).withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)this.getTip("2", new ChatFormatting[0]).withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.recover.tip").withStyle(ChatFormatting.BOLD));
        }
        if (stack.is((Item)ModItems.JIU)) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.recover.tip").withStyle(ChatFormatting.BOLD));
        }
        if (stack.is((Item)ModItems.FIRE_ATTACK) || stack.is((Item)ModItems.JIEDAO) || stack.is((Item)ModItems.NANMAN) || stack.is((Item)ModItems.TAOYUAN) || stack.is((Item)ModItems.TIESUO) || stack.is((Item)ModItems.JUEDOU)) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }
        if (stack.is((Item)ModItems.SHANDIAN_ITEM) || stack.is((Item)ModItems.WUGU) || stack.is((Item)ModItems.WUXIE) || stack.is((Item)ModItems.STEAL) || stack.is((Item)ModItems.WUZHONG) || stack.is((Item)ModItems.DISCARD)) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", new ChatFormatting[0]));
        }
        if (stack.is((Item)ModItems.BINGLIANG_ITEM)) {
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
                tooltip.add((Component)this.getTip("2", new ChatFormatting[0]));
            } else {
                tooltip.add((Component)this.getTip(new ChatFormatting[0]).withStyle(ChatFormatting.BLUE));
                tooltip.add((Component)Component.translatable((String)"dabaosword.shift_tip", (Object[])new Object[]{Component.keybind((String)"key.sneak")}));
            }
        }
        if (stack.is((Item)ModItems.TOO_HAPPY_ITEM)) {
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
                tooltip.add((Component)this.getTip("2", new ChatFormatting[0]));
            } else {
                tooltip.add((Component)this.getTip(new ChatFormatting[0]).withStyle(ChatFormatting.RED));
                tooltip.add((Component)Component.translatable((String)"dabaosword.shift_tip", (Object[])new Object[]{Component.keybind((String)"key.sneak")}));
            }
        }
        if ((item = stack.getItem()) instanceof CardItem && (c = (CardItem)item).rangedUse()) {
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.long_hand").withStyle(ChatFormatting.BOLD));
        }
        if (stack.is((Item)ModItems.WANJIAN)) {
            if (Screen.hasShiftDown()) {
                int i = (int)(System.currentTimeMillis() / 1000L) % 7;
                switch (i) {
                    case 1: {
                        tooltip.add((Component)this.getTip("1", new ChatFormatting[0]).withStyle(ChatFormatting.AQUA));
                        break;
                    }
                    case 2: {
                        tooltip.add((Component)this.getTip("2", new ChatFormatting[0]).withStyle(ChatFormatting.RED));
                        break;
                    }
                    case 3: {
                        tooltip.add((Component)this.getTip("3", new ChatFormatting[0]).withStyle(ChatFormatting.GOLD));
                        break;
                    }
                    case 4: {
                        tooltip.add((Component)this.getTip("4", new ChatFormatting[0]).withStyle(ChatFormatting.GREEN));
                        break;
                    }
                    case 5: {
                        tooltip.add((Component)this.getTip("5", new ChatFormatting[0]).withStyle(ChatFormatting.DARK_PURPLE));
                        break;
                    }
                    case 6: {
                        tooltip.add((Component)this.getTip("6", new ChatFormatting[0]).withStyle(ChatFormatting.YELLOW));
                        break;
                    }
                    case 0: {
                        tooltip.add((Component)this.getTip("7", new ChatFormatting[0]).withStyle(ChatFormatting.BLUE));
                    }
                }
            } else {
                tooltip.add((Component)this.getTip(new ChatFormatting[0]));
                tooltip.add((Component)Component.translatable((String)"item.dabaosword.wanjian.shift", (Object[])new Object[]{Component.keybind((String)"key.sneak")}).withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    public MutableComponent getTip(ChatFormatting ... format) {
        return this.getTip("", format);
    }

    public MutableComponent getTip(String suffix, ChatFormatting ... format) {
        return Component.translatable((String)(this.getDescriptionId() + ".tooltip" + suffix)).withStyle(format);
    }

    public final void addSRTip(Card card, List<Component> tooltip) {
        if (card.suit == Suit.None || card.rank == Rank.None) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"card.suit_and_rank", (Object[])new Object[]{card.suit.suit, card.rank.rank}).withStyle(card.suit.color));
    }

    public static void onUse(LivingEntity user, ItemStack stack, InteractionHand hand, LivingEntity ... targets) {
        CardItem.onUse(user, stack, hand, false, targets);
    }

    public static void onUse(LivingEntity user, ItemStack stack, InteractionHand hand, boolean noTarget, LivingEntity ... targets) {
        CardItem.onUse(user, stack, hand, noTarget, true, targets);
    }

    public static void onUse(LivingEntity user, ItemStack stack, InteractionHand hand, boolean noTarget, boolean consume, LivingEntity ... targets) {
        Card card = ModTools.c(stack);
        ExData cardData = ModTools.d().cards(card, card.count, new boolean[0]);
        if (consume) {
            CardEvents.cardUseAndDecrement(user, stack, hand);
        }
        if (card.type != 2) {
            ModTools.voice(user, card.item(), new float[0]);
        }
        List<LivingEntity> owners = ModTools.getSkillOwners(user);
        owners.forEach(player -> ModTools.getResult(Trigger.LOSE_CARD_USE, player, user, cardData));
        if (noTarget) {
            return;
        }
        ExData data = cardData.withTargets(targets);
        owners.forEach(player -> ModTools.getResult(Trigger.ADD_TARGET, player, user, data));
        owners.forEach(player -> ModTools.getResult(Trigger.DROP_TARGET, player, user, data));
        for (LivingEntity target : data.targets) {
            ModTools.getResult(Trigger.SELECT_TARGET, user, target, cardData);
            owners.forEach(player -> ModTools.getResult(Trigger.BECOME_TARGET, player, target, cardData));
            if (card.askForWuxie() && ModTools.hasCard(target, ModTools.p(ModItems.WUXIE))) {
                CardItem.onUse(target, new ItemStack((ItemLike)ModItems.WUXIE), null, true, new LivingEntity[0]);
                continue;
            }
            card.effect(user, card.toStack(), target);
        }
    }

    public static class Empty
    extends CardItem {
        public Empty() {
            super(new Item.Properties());
        }

        @Override
        public int getType() {
            return 114;
        }
    }

    public static class Armoury
    extends CardItem {
        public Armoury() {
            super(new Item.Properties());
        }

        @Override
        public final int getType() {
            return 1;
        }

        public boolean askForWuxie() {
            return false;
        }
    }

    public static class Basic
    extends CardItem {
        public Basic() {
            super(new Item.Properties());
        }

        @Override
        public final int getType() {
            return 0;
        }
    }
}

