/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DiscardItem
extends CardItem.Armoury {
    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        if (!user.level().isClientSide && ModTools.countAllCards(entity) > 0) {
            DiscardItem.onUse((LivingEntity)user, user.getItemInHand(hand), hand, entity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void effect(LivingEntity user, ItemStack card, LivingEntity entity) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (entity instanceof Player) {
                Player target = (Player)entity;
                ModTools.openInv(player, target, target, (Component)Component.translatable((String)"dabaosword.discard.title", (Object[])new Object[]{card.getDisplayName()}), card, true, false, 1);
            } else {
                List<ItemStack> stacks = ModTools.getItems(entity, ModTools.isCard, true, false, true, false);
                if (!stacks.isEmpty()) {
                    ItemStack chosen = stacks.get(new Random().nextInt(stacks.size()));
                    ExData exData = ModTools.d().cards(chosen, 1, ModTools.isEquipped(entity, s -> s.equals(chosen)));
                    CardEvents.cardDiscard(entity, exData);
                }
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            List<ItemStack> candidate = ModTools.getItems(entity, ModTools.isCard, true, false, true, true);
            if (!candidate.isEmpty()) {
                ItemStack chosen = candidate.get(new Random().nextInt(candidate.size()));
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.discard", (Object[])new Object[]{user.getDisplayName(), player.getDisplayName(), chosen.getDisplayName()}), false);
                ExData exData = ModTools.d().cards(chosen, 1, ModTools.isEquipped(entity, s -> s.equals(chosen)));
                CardEvents.cardDiscard((LivingEntity)player, exData);
            }
        } else {
            List<ItemStack> candidate = ModTools.getItems(entity, s -> !s.isEmpty(), true, true, true, false);
            if (!candidate.isEmpty()) {
                ItemStack chosen = candidate.get(new Random().nextInt(candidate.size()));
                if (ModTools.isCard(chosen)) {
                    ExData exData = ModTools.d().cards(chosen, 1, ModTools.isEquipped(entity, s -> s.equals(chosen)));
                    CardEvents.cardDiscard(entity, exData);
                } else {
                    chosen.shrink(1);
                }
            }
        }
    }

    @Override
    public boolean rangedUse() {
        return true;
    }

    @Override
    public boolean askForWuxie() {
        return true;
    }
}

