/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NanmanItem
extends CardItem.Armoury {
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)world;
            HashSet targets = new HashSet(sw.players());
            AABB box = new AABB(user.getOnPos()).inflate(10.0);
            Predicate<LivingEntity> p = e -> e.isAlive() && !e.getTags().contains("b");
            targets.addAll(world.getEntitiesOfClass(LivingEntity.class, box, p));
            targets.remove(user);
            user.addTag("nanman");
            NanmanItem.onUse((LivingEntity)user, user.getItemInHand(hand), hand, targets.toArray(new LivingEntity[0]));
            return InteractionResultHolder.success((Object)user.getItemInHand(hand));
        }
        return super.use(world, user, hand);
    }

    @Override
    public void effect(LivingEntity user, ItemStack card, LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 2, 0, false, false));
        entity.hurt(ModDT.nanman((Entity)user), 6.0f);
        this.summonRavager(entity);
    }

    private void summonRavager(LivingEntity entity) {
        Level world = entity.level();
        Ravager ravager = new Ravager(EntityType.RAVAGER, world);
        ravager.setCustomName(Component.nullToEmpty((String)String.valueOf(entity.getId())));
        world.addFreshEntity((Entity)ravager);
        ravager.setInvulnerable(true);
        ravager.addTag("a");
        ravager.addTag("b");
        ravager.moveTo(this.getBlockInFront(entity, 3));
    }

    public Vec3 getBlockInFront(LivingEntity entity, int distance) {
        Vec3 pos = entity.position();
        Vec3 playerDirection = entity.getViewVector(1.0f);
        double x = pos.x + playerDirection.x * (double)distance;
        double z = pos.z + playerDirection.z * (double)distance;
        return new Vec3(x, pos.y, z);
    }

    @Override
    public boolean askForWuxie() {
        return true;
    }
}

