/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.effect.ShandianEffect;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class Sha
extends CardItem.Basic {
    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.sha.tip").withStyle(ChatFormatting.BOLD));
        if (stack.is((Item)ModItems.SHA)) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }
        if (stack.is((Item)ModItems.FIRE_SHA)) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]).withStyle(ChatFormatting.RED));
        }
        if (stack.is((Item)ModItems.THUNDER_SHA)) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]).withStyle(ChatFormatting.BLUE));
        }
    }

    public static void shaUse(LivingEntity user, ItemStack stack, InteractionHand hand, float amount, LivingEntity ... targets) {
        Sha.shaUse(user, stack, hand, amount, true, targets);
    }

    public static void shaUse(LivingEntity user, ItemStack stack, InteractionHand hand, float amount, boolean consume, LivingEntity ... targets) {
        Card card = ModTools.c(stack);
        ExData cardData = ModTools.d().cards(card, card.count, new boolean[0]);
        if (consume) {
            CardEvents.cardUseAndDecrement(user, stack, hand);
        }
        ModTools.voice(user, card.item(), new float[0]);
        List<LivingEntity> owners = ModTools.getSkillOwners(user);
        owners.forEach(player -> ModTools.getResult(Trigger.LOSE_CARD_USE, player, user, cardData));
        ExData data = cardData.withTargets(targets);
        owners.forEach(player -> ModTools.getResult(Trigger.ADD_TARGET, player, user, data));
        owners.forEach(player -> ModTools.getResult(Trigger.DROP_TARGET, player, user, data));
        for (LivingEntity entity : data.targets) {
            ModTools.getResult(Trigger.SELECT_TARGET, user, entity, cardData);
            owners.forEach(player -> ModTools.getResult(Trigger.BECOME_TARGET, player, entity, cardData));
            Sha sha = (Sha)card.toStack().getItem();
            if (sha.sha(user, entity, amount)) {
                sha.effect(user, card.toStack(), entity);
                continue;
            }
            Skill guanshi = ModTools.s(ModTools.trinketItem(ModItems.GUANSHI, user));
            if (guanshi.isEmpty() || guanshi.getCD() != 0 || !entity.hasEffect(ModItems.INVULNERABLE)) continue;
            guanshi.setCD(10);
            ModTools.voice(user, guanshi.stack, new float[0]);
            entity.removeEffect(ModItems.INVULNERABLE);
            if (!sha.sha(user, entity, amount)) continue;
            sha.effect(user, card.toStack(), entity);
        }
    }

    public boolean sha(LivingEntity user, LivingEntity target, float amount) {
        return target.hurt(ModDT.sha((Entity)user), amount + 5.0f);
    }

    public static class Thunder
    extends Sha {
        @Override
        public boolean sha(LivingEntity user, LivingEntity target, float amount) {
            return target.hurt(ModDT.shaThunder((Entity)user), amount + 5.0f);
        }

        @Override
        public void effect(LivingEntity user, ItemStack sha, LivingEntity target) {
            ShandianEffect.summonLightning(target, true, false);
        }
    }

    public static class Fire
    extends Sha {
        @Override
        public boolean sha(LivingEntity user, LivingEntity target, float amount) {
            return target.hurt(ModDT.shaFire((Entity)user), amount);
        }

        @Override
        public void effect(LivingEntity user, ItemStack sha, LivingEntity target) {
            target.setRemainingFireTicks(120);
        }
    }
}

