/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StealItem
extends CardItem.Armoury {
    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        if (!user.level().isClientSide && this.canSteal(entity)) {
            StealItem.onUse((LivingEntity)user, user.getItemInHand(hand), hand, entity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void effect(LivingEntity user, ItemStack card, LivingEntity entity) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (entity instanceof Player) {
                Player target = (Player)entity;
                ModTools.openInv(player, target, target, (Component)Component.translatable((String)"dabaosword.steal.title"), card, true, true, 1);
            } else {
                List<ItemStack> stacks = ModTools.getItems(entity, ModTools.isCard, true, false, true, false);
                if (!stacks.isEmpty()) {
                    ItemStack chosen = stacks.get(new Random().nextInt(stacks.size()));
                    ExData exData = ModTools.d().cards(chosen, 1, ModTools.isEquipped(entity, s -> s.equals(chosen)));
                    CardEvents.cardMove(entity, exData, (LivingEntity)player);
                }
            }
        }
    }

    @Override
    public boolean askForWuxie() {
        return true;
    }

    private boolean canSteal(LivingEntity entity) {
        int count = ModTools.countAllCards(entity);
        for (ItemStack stack : entity.getArmorSlots()) {
            count += stack.getCount();
        }
        return count > 0;
    }
}

