/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card.equipment;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.equipment.Equipment;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.ModifyDamage;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class Armor
extends Equipment {

    public static class Rattan
    extends Armor {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public void tickSkill(Skill skill, LivingEntity entity) {
            BlockPos pos;
            boolean water;
            if (entity.isShiftKeyDown()) {
                return;
            }
            Level world = entity.level();
            boolean bl = water = !world.getFluidState(pos = entity.getOnPos()).is((Fluid)Fluids.WATER) && world.getFluidState(pos.below()).is((Fluid)Fluids.WATER);
            if (water && entity.position().y - (double)pos.getY() < 0.15) {
                Vec3 motion = entity.getDeltaMovement();
                entity.setDeltaMovement(motion.x, 0.0, motion.z);
                entity.fallDistance = 0.0f;
                entity.setOnGround(true);
            }
        }

        @SkillInfo(trigger={Trigger.MODIFY_DAMAGE}, relation=Relation.SELF)
        public int shouyi(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            DamageSource source = data.source;
            List<Float> adds = data.adds;
            Float amount = data.amount;
            if (source.is(DamageTypeTags.IS_FIRE)) {
                ModTools.voice(target, "rattan_armor2", new float[0]);
                adds.add(Float.valueOf(Math.min(amount.floatValue(), 5.0f)));
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.DROP_TARGET}, relation=Relation.ANY)
        public int goodEffect(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            boolean bl;
            ItemStack card = data.getFirst(new boolean[0]).toStack();
            boolean bl2 = bl = card.is((Item)ModItems.WANJIAN) || card.is((Item)ModItems.NANMAN) || card.is((Item)ModItems.SHA);
            if (data.targets.contains(user) && bl) {
                ModTools.voice(user, this, new float[0]);
                data.removeTarget(user);
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.CANCEL_DAMAGE_HIGH}, relation=Relation.SELF)
        public int tengjia(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            LivingEntity s;
            Entity entity;
            DamageSource source = data.source;
            if (source.is(DamageTypeTags.IS_PROJECTILE)) {
                Entity projectile = source.getDirectEntity();
                if (projectile instanceof Arrow) {
                    projectile.discard();
                    ModTools.voice(target, this, new float[0]);
                    return 1;
                }
                if (skill.getCD() == 0) {
                    if (projectile != null) {
                        projectile.discard();
                    }
                    target.addEffect(new MobEffectInstance(ModItems.INVULNERABLE, 10, 0, false, false, false));
                    skill.setCD(5);
                    ModTools.voice(target, this, new float[0]);
                    return 1;
                }
            }
            if ((entity = source.getDirectEntity()) instanceof LivingEntity && (s = (LivingEntity)entity).getMainHandItem().isEmpty() && skill.getCD() == 0) {
                target.addEffect(new MobEffectInstance(ModItems.INVULNERABLE, 10, 0, false, false, false));
                skill.setCD(5);
                ModTools.voice(target, this, new float[0]);
                return 1;
            }
            return 0;
        }
    }

    public static class Renwang
    extends Armor {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.DROP_TARGET}, relation=Relation.ANY)
        public int fangheisha(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (data.targets.contains(user) && ModTools.isSha.and(ModTools.isBlackCard).test(data.getFirst(new boolean[0]).toStack())) {
                ModTools.voice(user, this, new float[0]);
                data.removeTarget(user);
            }
            return 0;
        }
    }

    public static class Baiyin
    extends Armor {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.MODIFY_DAMAGE}, relation=Relation.SELF)
        public int jianshang(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            DamageSource source = data.source;
            List<Float> muls = data.muls;
            if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && source.getEntity() instanceof LivingEntity) {
                ModTools.voice(target, this, new float[0]);
                muls.add(Float.valueOf(-0.4f));
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_DISCARD, Trigger.LOSE_CARD_MOVE}, relation=Relation.SELF)
        public int recover(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (user.isAlive() && user.getHealth() < user.getMaxHealth()) {
                for (Card card : data.cards_from_equ.keySet()) {
                    if (!card.toStack().is((Item)this)) continue;
                    ModTools.voice(user, this, new float[0]);
                    user.heal(5.0f);
                }
            }
            return 0;
        }
    }

    public static class Bagua
    extends Armor {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.CANCEL_DAMAGE_HIGH}, relation=Relation.SELF)
        public int bagua(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            DamageSource source = data.source;
            if (source.getEntity() instanceof LivingEntity && !user.hasEffect(ModItems.COOLDOWN2)) {
                Random random = new Random();
                if ((double)random.nextFloat() < 0.5 && !source.is(DamageTypeTags.BYPASSES_ARMOR)) {
                    ModTools.voice(user, this, new float[0]);
                    ItemStack shan = new ItemStack((ItemLike)ModItems.SHAN);
                    Bagua.onUse(user, shan, null, true, false, new LivingEntity[0]);
                    ModifyDamage.shan(user, true, source, data.amount.floatValue());
                    return 1;
                }
            }
            return 0;
        }
    }
}

