/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card.equipment;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class Equipment
extends CardItem
implements ISkill {
    public Equipment() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public final boolean lockOn() {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (slotId != -1 && !level.isClientSide && this.equipped(stack)) {
            this.setEquipped(stack, false);
        }
    }

    @Override
    public final void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        this.addSRTip(ModTools.c(stack), tooltip);
        this.addTip(ModTools.s(stack), tooltip);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"equipment.tip1").withStyle(ChatFormatting.BOLD));
            tooltip.add((Component)Component.translatable((String)"equipment.tip2").withStyle(ChatFormatting.BOLD));
        } else {
            tooltip.add((Component)Component.translatable((String)"dabaosword.shift_tip", (Object[])new Object[]{Component.keybind((String)"key.sneak")}));
        }
    }

    public void addTip(Skill skill, List<Component> tooltip) {
    }

    @Override
    public final void addTip(ItemStack stack, List<Component> tooltip) {
    }

    public final boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity entity = slotContext.entity();
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            return false;
        }
        return ISkill.super.canUnequip(slotContext, stack);
    }

    @Override
    public final void curioTick(SlotContext slotContext, ItemStack stack) {
        ISkill.super.curioTick(slotContext, stack);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            Equipment.onUse((LivingEntity)user, stack, hand, new LivingEntity[]{user});
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public final void effect(LivingEntity user, ItemStack card, LivingEntity target) {
        Equipment.useOrReplaceEquip(target, card);
    }

    public static void useOrReplaceEquip(LivingEntity entity, ItemStack stack) {
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (optional.isPresent()) {
            Map curios = ((ICuriosItemHandler)optional.get()).getCurios();
            Tuple firstSlot = null;
            for (Map.Entry entry : curios.entrySet()) {
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    String id = (String)entry.getKey();
                    NonNullList renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                    SlotContext slotContext = new SlotContext(id, entity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    if (!stackHandler.isItemValid(i, stack)) continue;
                    ItemStack present = stackHandler.getStackInSlot(i);
                    if (present.isEmpty()) {
                        stackHandler.setStackInSlot(i, stack.copy());
                        return;
                    }
                    if (firstSlot != null) continue;
                    firstSlot = new Tuple((Object)stackHandler, (Object)slotContext);
                }
            }
            if (firstSlot != null) {
                IDynamicStackHandler stackHandler = (IDynamicStackHandler)firstSlot.getA();
                SlotContext slotContext = (SlotContext)firstSlot.getB();
                int i = slotContext.index();
                ItemStack present = stackHandler.getStackInSlot(i);
                CardEvents.cardDiscard(entity, ModTools.d().cards(present, present.getCount(), true));
                stackHandler.setStackInSlot(i, stack.copy());
            }
        }
    }
}

