/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.card.equipment;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.equipment.Equipment;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.util.ModTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class Weapon
extends Equipment {

    public static class Zhuque
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.ATTACKER)
        public int fire(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            ModTools.voice(user, this, new float[0]);
            target.setRemainingFireTicks(80);
            return 0;
        }
    }

    public static class Zhangba
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_USE}, relation=Relation.SELF)
        public int useCardGetSha(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (skill.getCD() > 0) {
                return 0;
            }
            ItemStack stack = data.getFirst(new boolean[0]).toStack();
            if (ModTools.isSha.test(stack)) {
                return 0;
            }
            skill.setTag(skill.getTag() + 1);
            if (skill.getTag() >= 2) {
                skill.setTag(0);
                skill.setCD(1);
                ModTools.give(user, new Card(ModItems.SHA).toStack(), new int[0]);
            }
            return 0;
        }
    }

    public static class Qinglong
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            ModTools.voice((LivingEntity)player, this, new float[0]);
            player.addEffect(new MobEffectInstance(ModItems.INVULNERABLE, 10, 0, false, false, false));
            player.teleportTo(target.getX(), target.getY(), target.getZ());
            Vec3 momentum = player.getForward().scale(2.0);
            target.hurtMarked = true;
            target.setDeltaMovement(momentum.x, 0.0, momentum.z);
        }
    }

    public static class Qinggang
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            if (player.getAttackStrengthScale(0.0f) < 1.0f) {
                return;
            }
            float extraDamage = Math.min(20.0f, 0.2f * target.getMaxHealth());
            target.hurt(player.damageSources().genericKill(), extraDamage);
            target.invulnerableTime = 0;
            ModTools.voice((LivingEntity)player, this, new float[0]);
        }
    }

    public static class Qilin
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
            tooltip.add((Component)this.getTip("3", ChatFormatting.AQUA));
        }

        @Override
        public int getExtraReach(LivingEntity entity, Skill skill) {
            return 1;
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.ATTACKER)
        public int nimameile(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Player player;
            if (skill.getCD() != 0) {
                return 0;
            }
            ItemStack chitu = ModTools.trinketItem(ModItems.CHITU, target);
            ItemStack dilu = ModTools.trinketItem(ModItems.DILU, target);
            ArrayList<ItemStack> horse = new ArrayList<ItemStack>();
            if (!chitu.isEmpty()) {
                horse.add(chitu);
            }
            if (!dilu.isEmpty()) {
                horse.add(dilu);
            }
            if (horse.isEmpty()) {
                return 0;
            }
            ItemStack selected = (ItemStack)horse.get(new Random().nextInt(horse.size()));
            MutableComponent message = Component.translatable((String)"dabaosword.discard", (Object[])new Object[]{user.getDisplayName(), target.getDisplayName(), selected.getDisplayName()});
            if (user instanceof Player) {
                player = (Player)user;
                player.displayClientMessage((Component)message, false);
            }
            if (target instanceof Player) {
                player = (Player)target;
                player.displayClientMessage((Component)message, false);
            }
            CardEvents.cardDiscard(target, ModTools.d().cards(selected, 1, true));
            ModTools.voice(user, this, new float[0]);
            skill.setCD(30);
            return 0;
        }
    }

    public static class Liannu
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            int i = 2;
            if (ModTools.hasTrinket(ModItems.CHITU, (LivingEntity)player)) {
                ++i;
            }
            if (ModTools.hasTrinket(SkillCards.MASHU, (LivingEntity)player)) {
                ++i;
            }
            if (ModTools.hasTrinket(ModItems.DILU, target)) {
                --i;
            }
            if (ModTools.hasTrinket(SkillCards.FEIYING, target)) {
                --i;
            }
            if (player.distanceTo((Entity)target) <= (float)i) {
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 3, 255, false, false, false));
                ModTools.voice((LivingEntity)player, this, new float[0]);
            }
        }
    }

    public static class Hanbing
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.DIRECT_ATTACKER)
        public int onHit(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            ModTools.voice(user, this, new float[0]);
            target.invulnerableTime = 0;
            target.setTicksFrozen(500);
            return 0;
        }
    }

    public static class Guding
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.gudingdao.tooltip").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.gudingdao.tooltip2").withStyle(ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.MODIFY_DAMAGE}, relation=Relation.DIRECT_ATTACKER)
        public int addDamage(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            List<Float> adds = data.adds;
            int i = 0;
            for (ItemStack s : target.getArmorSlots()) {
                if (!s.isEmpty()) continue;
                ++i;
            }
            if (i == 4) {
                ModTools.voice(user, this, new float[0]);
                adds.add(Float.valueOf(5.0f));
            }
            return 0;
        }
    }

    public static class Guanshi
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }
    }

    public static class Fangtian
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            if (skill.getCD() == 0) {
                skill.setCD(20);
                ModTools.voice((LivingEntity)player, this, new float[0]);
                player.displayClientMessage((Component)Component.translatable((String)"dabaosword.fangtian").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    public static class Cixiong
    extends Weapon {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", ChatFormatting.AQUA));
        }

        @SkillInfo(trigger={Trigger.SELECT_TARGET}, relation=Relation.NOT_SELF)
        public int onSha(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Card card = data.getFirst(new boolean[0]);
            if (ModTools.isSha.test(card.toStack()) && target != null) {
                Random random = new Random();
                if ((double)random.nextFloat() < 0.5) {
                    ModTools.draw(user, new int[0]);
                    ModTools.voice(user, this, new float[0]);
                }
            }
            return 0;
        }
    }
}

