/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class SkillItem
extends Item
implements ISkill {
    public SkillItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (slotId != -1 && !level.isClientSide && this.equipped(stack)) {
            this.setEquipped(stack, false);
        }
    }

    public void appendHoverText(ItemStack s, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        this.addTip(ModTools.s(s), t);
    }

    public void addTip(Skill skill, List<Component> tooltip) {
    }

    public MutableComponent getTip(ChatFormatting ... format) {
        return this.getTip("", format);
    }

    public MutableComponent getTip(String suffix, ChatFormatting ... format) {
        return Component.translatable((String)(this.getDescriptionId() + ".tooltip" + suffix)).withStyle(format);
    }

    @Override
    public final void curioTick(SlotContext slotContext, ItemStack stack) {
        ISkill.super.curioTick(slotContext, stack);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack;
        if (!world.isClientSide && user.getTags().contains("change_skill") && hand == InteractionHand.OFF_HAND && user.isShiftKeyDown() && (stack = user.getItemInHand(hand)).getItem() instanceof SkillItem) {
            stack.setCount(0);
            SkillItem.changeSkill(user);
            user.getTags().remove("change_skill");
        }
        return super.use(world, user, hand);
    }

    public static void changeSkill(Player player) {
        ItemStack stack = ModTools.customLoot((LivingEntity)player, "draw_skill");
        if (!stack.isEmpty()) {
            ModTools.voice((LivingEntity)player, "giftbox", 3.0f);
        }
        ModTools.give((LivingEntity)player, stack, new int[0]);
    }

    public Component activeSkillText(Player user, Skill skill) {
        return Component.translatable((String)"active_skill.select_target").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/dabaosword " + user.getName().getString() + " " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)skill.stack.getItem())) + " ")));
    }
}

