/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public abstract class ConvertSkill
extends SkillItem {
    public abstract Predicate<ItemStack> getConvertFilter();

    public boolean chooseEquipment() {
        return false;
    }

    public abstract CardItem convert(ItemStack var1);

    @Override
    public boolean isActiveSkill() {
        return true;
    }

    @Override
    public void addScreenTip(Skill skill, List<Component> tips) {
        this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 3, 4});
        super.addScreenTip(skill, tips);
    }

    @Override
    public boolean activeSkill(Player user, Skill skill) {
        if (skill.getCD() > 0) {
            return false;
        }
        if (ModTools.count((LivingEntity)user, this.getConvertFilter(), false, true, this.chooseEquipment()) > 0) {
            skill.setMaxSelect(64);
            ModTools.openInv(user, user, user, skill.toHoverableText(), skill.stack, this.chooseEquipment(), false, 2);
            return true;
        }
        return false;
    }

    @Override
    public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
        ItemStack clicked = handler.getStack(slot);
        if (this.getConvertFilter().test(clicked)) {
            super.onSlotClick(handler, player, skill, target, slot, button, action);
        }
    }

    @Override
    public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
        if (handler.getSelectedCount() > 0) {
            ModTools.voice((LivingEntity)player, this, new float[0]);
            ExData data = handler.toExData();
            data.forEachCard(3, (card, count) -> {
                ItemStack stack = card.toStack();
                ModTools.give((LivingEntity)player, ModTools.c(stack, this.convert(stack)).toStack().copyWithCount(count.intValue()), new int[0]);
            });
            data.clearCards((LivingEntity)player);
        }
    }
}

