/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.command.DabaoSwordCommand;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.item.skillcard.skills.ConvertSkill;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Qun {

    public static class Feiying
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.dilu.tooltip"));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @Override
        public int getDefend(LivingEntity entity, Skill skill) {
            return 1;
        }
    }

    public static class Mashu
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"item.dabaosword.chitu.tooltip"));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @Override
        public int getExtraReach(LivingEntity entity, Skill skill) {
            return 1;
        }
    }

    public static class Weimu
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.DROP_TARGET}, relation=Relation.ANY)
        public int weimu(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Card card = data.getFirst(new boolean[0]);
            if (data.targets.contains(user) && ModTools.isBlackCard.and(ModTools.isArmoury).test(card.toStack())) {
                data.removeTarget(user);
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }
    }

    public static class Taoluan
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            List<Item> items = BuiltInRegistries.ITEM.stream().filter(item -> {
                CardItem card;
                return item instanceof CardItem && (card = (CardItem)((Object)item)).getType() < 2;
            }).toList();
            String[] used = skill.getNbt().getString("used").split(";");
            if (used.length == items.size()) {
                user.displayClientMessage((Component)Component.translatable((String)"item.dabaosword.taoluan.fail").withStyle(ChatFormatting.RED), true);
                return false;
            }
            if ((double)(user.getHealth() + (float)(5 * ModTools.countCard((LivingEntity)user, ModTools.canSaveDying))) > 4.99) {
                List<ItemStack> stacks = items.stream().filter(i -> !Arrays.stream(used).toList().contains(BuiltInRegistries.ITEM.getKey(i).getPath())).map(ItemStack::new).toList();
                ModTools.openMenu(user, user, skill.stack, stacks, (Component)Component.translatable((String)"item.dabaosword.taoluan.screen"));
                return true;
            }
            user.displayClientMessage((Component)Component.translatable((String)"item.dabaosword.taoluan.tip").withStyle(ChatFormatting.RED), true);
            return false;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
            ItemStack selected = handler.getStack(slot);
            ModTools.give((LivingEntity)player, selected, new int[0]);
            if (!player.isCreative()) {
                CompoundTag nbt = skill.getNbt();
                String used = nbt.getString("used");
                String item = BuiltInRegistries.ITEM.getKey((Object)selected.getItem()).getPath();
                used = used.isEmpty() ? item : used + ";" + item;
                nbt.putString("used", used);
                skill.setNbt(nbt);
                player.invulnerableTime = 0;
                player.hurt(ModDT.loseHP((Entity)player), 4.99f);
            }
            ModTools.voice((LivingEntity)player, this, new float[0]);
            ModTools.closeGUI(player);
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.SELF)
        public int refresh(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            CompoundTag nbt = skill.getNbt();
            nbt.remove("used");
            skill.setNbt(nbt);
            return 0;
        }
    }

    public static class Luanji
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 15s" : "CD: 15s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public void addScreenTip(Skill skill, List<Component> tips) {
            this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 4, 5});
            super.addScreenTip(skill, tips);
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            if (skill.getCD() > 0) {
                return false;
            }
            if (this.ofSuit(user, ModTools.isDiamondCard) || this.ofSuit(user, ModTools.isHeartCard) || this.ofSuit(user, ModTools.isClubCard) || this.ofSuit(user, ModTools.isSpadeCard)) {
                skill.setMaxSelect(2);
                ModTools.openInv(user, user, user, (Component)Component.translatable((String)"item.dabaosword.luanji.suit"), skill.stack, false, false, 2);
                return true;
            }
            return false;
        }

        boolean ofSuit(Player user, Predicate<ItemStack> p) {
            return ModTools.countCard((LivingEntity)user, p) > 1;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
            boolean bl;
            int count = handler.getSelectedCount();
            List<ItemStack> selects = handler.getSelected();
            ItemStack choose = handler.getStack(slot);
            boolean bl2 = bl = count == 0 || ModTools.c((ItemStack)selects.getFirst()).suit == ModTools.c((ItemStack)choose).suit;
            if (bl && action == ClickType.PICKUP) {
                if (button == 0) {
                    handler.addClick(slot, new int[0]);
                }
                if (button == 1) {
                    handler.dropClick(slot, new int[0]);
                }
            }
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
            if (handler.getSelectedCount() == 2) {
                ModTools.voice((LivingEntity)player, this, new float[0]);
                skill.setCD(15);
                Card card = new Card(ModItems.WANJIAN, ModTools.c((ItemStack)handler.getSelected().getFirst()).suit, Rank.Ace);
                handler.toExData().clearCards((LivingEntity)player);
                ModTools.give((LivingEntity)player, card.toStack(), new int[0]);
            }
        }
    }

    public static class Leiji
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_USE}, relation=Relation.SELF)
        public int useShan(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Card card = data.getFirst(new boolean[0]);
            if (card.isOf(ModItems.SHAN)) {
                ModTools.voice(user, this, new float[0]);
                user.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 10, 3, false, false, false));
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.CANCEL_DAMAGE_HIGH}, relation=Relation.SELF)
        public int fanglei(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            DamageSource source = data.source;
            if (source.is(DamageTypes.LIGHTNING_BOLT) && source.getEntity() == null) {
                return 1;
            }
            return 0;
        }
    }

    public static class Jizhan
    extends SkillItem
    implements DabaoSwordCommand.CSkill {
        private final Component JIZHAN_TEXT = Component.translatable((String)"jizhan.text", (Object[])new Object[]{Component.translatable((String)"rank.higher").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword @s dabaosword:jizhan @s 1"))), Component.translatable((String)"rank.lower").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword @s dabaosword:jizhan @s -1")))});

        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", new ChatFormatting[0]));
            tooltip.add((Component)this.getTip("2", new ChatFormatting[0]));
        }

        @Override
        public int onDrawPhase(Player player, Skill skill) {
            ModTools.voice((LivingEntity)player, this, new float[0]);
            ItemStack last = ModTools.newCard();
            ModTools.give((LivingEntity)player, last, new int[0]);
            player.level().players().forEach(p -> p.displayClientMessage((Component)Component.translatable((String)"jizhan.draw", (Object[])new Object[]{player.getDisplayName(), skill.toHoverableText(), last.getDisplayName(), ModTools.c((ItemStack)last).rank.rank}), false));
            CompoundTag tag = skill.getNbt();
            tag.putInt("lastCardRank", ModTools.c((ItemStack)last).rank.ordinal());
            skill.setNbt(tag);
            player.displayClientMessage(this.JIZHAN_TEXT, false);
            return -114;
        }

        @Override
        public void triggerSkill(LivingEntity entity, Skill skill, LivingEntity target, int value) {
            int last = skill.getNbt().getInt("lastCardRank");
            if (last == -1 || !(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack next = ModTools.newCard();
            ModTools.give((LivingEntity)player, next, new int[0]);
            player.level().players().forEach(p -> p.displayClientMessage((Component)Component.translatable((String)"jizhan.draw", (Object[])new Object[]{player.getDisplayName(), skill.toHoverableText(), next.getDisplayName(), ModTools.c((ItemStack)next).rank.rank}), false));
            int cmp = Integer.compare(ModTools.c((ItemStack)next).rank.ordinal(), last);
            CompoundTag tag = skill.getNbt();
            if (cmp == value) {
                tag.putInt("lastCardRank", ModTools.c((ItemStack)next).rank.ordinal());
                player.displayClientMessage(this.JIZHAN_TEXT, false);
            } else {
                tag.putInt("lastCardRank", -1);
            }
            skill.setNbt(tag);
        }
    }

    public static class Jiuchi
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isSpadeCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.JIU;
        }
    }

    public static class Jijiu
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public boolean chooseEquipment() {
            return true;
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isRedCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.PEACH;
        }
    }

    public static class Duanchang
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(new ChatFormatting[0]));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.SELF)
        public int chicai(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Player killer = null;
            Entity attacker = data.source.getEntity();
            if (attacker instanceof Player) {
                Player player;
                killer = player = (Player)attacker;
            } else if (user.getKillCredit() != null) {
                killer = user.getKillCredit();
            }
            if (killer instanceof Player) {
                Player pl = killer;
                ModTools.voice(user, this, new float[0]);
                killer.addTag("duanchang");
                pl.displayClientMessage((Component)Component.translatable((String)"duanchang.tip").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
            }
            return 0;
        }
    }
}

