/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.event.PlayerEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.item.skillcard.skills.ConvertSkill;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class Shu {

    public static class Wusheng
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.RED));
            tooltip.add((Component)this.getTip("2", ChatFormatting.RED));
        }

        @Override
        public int getExtraReach(LivingEntity entity, Skill skill) {
            return ModTools.isSha.test(entity.getMainHandItem()) ? 13 : (ModTools.isSha.test(entity.getOffhandItem()) ? 13 : 0);
        }

        @Override
        public boolean chooseEquipment() {
            return true;
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isRedCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.SHA;
        }
    }

    public static class Tieji
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.RED));
            tooltip.add((Component)this.getTip("2", ChatFormatting.RED));
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            if (ModTools.hasItem((LivingEntity)player, ModTools.isSha)) {
                ModTools.voice((LivingEntity)player, this, new float[0]);
                target.addEffect(new MobEffectInstance(ModItems.TIEJI, 200, 0, false, true, true));
                Random random = new Random();
                if ((double)random.nextFloat() < 0.75) {
                    target.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 2, 0, false, false, false));
                }
            }
        }
    }

    public static class Rende
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 30s" : "CD: 30s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip("1", ChatFormatting.RED));
            tooltip.add((Component)this.getTip("2", ChatFormatting.RED));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public void addScreenTip(Skill skill, List<Component> tips) {
            this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 3, 4});
            super.addScreenTip(skill, tips);
        }

        @Override
        public boolean activeSkill(Player user, Skill skill, LivingEntity entity) {
            if (entity instanceof Player) {
                Player target = (Player)entity;
                if (ModTools.countCards((LivingEntity)user) > 0) {
                    ModTools.openInv(user, user, target, (Component)Component.translatable((String)"give_card.title", (Object[])new Object[]{skill.toHoverableText()}), skill.stack, false, false, 2);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
            int count = handler.getSelectedCount();
            if (count == 0) {
                return;
            }
            ModTools.voice((LivingEntity)player, this, new float[0]);
            MutableComponent message = Component.translatable((String)"give_card.tip", (Object[])new Object[]{player.getDisplayName(), skill.toHoverableText(), target.getDisplayName(), count});
            target.displayClientMessage((Component)message, false);
            player.displayClientMessage((Component)message, false);
            CardEvents.cardMove((LivingEntity)player, handler.toExData(), (LivingEntity)target);
            int cd = skill.getCD();
            if (player.getHealth() < player.getMaxHealth() && cd == 0) {
                Random random = new Random();
                if ((double)random.nextFloat() < 0.5 * (double)count) {
                    player.heal(5.0f);
                    ModTools.voice((LivingEntity)player, "peach", new float[0]);
                    player.displayClientMessage((Component)Component.translatable((String)"recover.tip").withStyle(ChatFormatting.GREEN), true);
                    skill.setCD(30);
                }
            }
        }
    }

    public static class Paoxiao
    extends SkillItem {
        @Override
        public boolean lockOn() {
            return true;
        }

        @Override
        public boolean shouldTickUpdate() {
            return true;
        }

        public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
            Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
            LivingEntity entity = slotContext.entity();
            boolean i = entity == null || !entity.getTags().contains("duanchang");
            modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(id, (double)i, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            return modifiers;
        }

        @SkillInfo(trigger={Trigger.SELECT_TARGET}, relation=Relation.NOT_SELF)
        public int yuyin(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (ModTools.isSha.test(data.getFirst(new boolean[0]).toStack())) {
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }
    }

    public static class Longdan
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.RED));
            tooltip.add((Component)this.getTip("2", ChatFormatting.RED));
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isBasic;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            if (stack.is((Item)ModItems.SHAN)) {
                return ModItems.SHA;
            }
            if (stack.is((Item)ModItems.PEACH)) {
                return ModItems.JIU;
            }
            if (stack.is((Item)ModItems.JIU)) {
                return ModItems.PEACH;
            }
            return ModItems.SHAN;
        }
    }

    public static class Liegong
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.RED));
            tooltip.add((Component)this.getTip("2", ChatFormatting.RED));
        }

        @Override
        public int getExtraReach(LivingEntity entity, Skill skill) {
            return entity.hasEffect(ModItems.COOLDOWN) ? 0 : 13;
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            if (!player.hasEffect(ModItems.COOLDOWN)) {
                target.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 2, 0, false, false, false));
            }
        }

        @SkillInfo(trigger={Trigger.MODIFY_DAMAGE}, relation=Relation.DIRECT_ATTACKER)
        public int addDamage(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            List<Float> adds = data.adds;
            if (!user.hasEffect(ModItems.COOLDOWN)) {
                float f = Math.max(13.0f - user.distanceTo((Entity)target), 5.0f);
                user.addEffect(new MobEffectInstance(ModItems.COOLDOWN, (int)(40.0f * f), 0, false, false, true));
                ModTools.voice(user, this, new float[0]);
                adds.add(Float.valueOf(f));
            }
            return 0;
        }
    }

    public static class Kuanggu
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)"CD: 8s"));
            tooltip.add((Component)this.getTip(ChatFormatting.RED));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.DIRECT_ATTACKER)
        public int onAttack(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (user.hasEffect(ModItems.COOLDOWN)) {
                return 0;
            }
            if (user.getMaxHealth() - user.getHealth() >= 5.0f) {
                user.heal(5.0f);
            } else {
                ModTools.draw(user, new int[0]);
            }
            ModTools.voice(user, this, new float[0]);
            user.addEffect(new MobEffectInstance(ModItems.COOLDOWN, 160, 0, false, false, true));
            return 0;
        }
    }

    public static class Kanpo
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.RED));
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isBlackCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.WUXIE;
        }
    }

    public static class Jizhi
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.RED));
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_USE}, relation=Relation.SELF)
        public int useCard(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            ItemStack card = data.getFirst(new boolean[0]).toStack();
            if (ModTools.isArmoury.test(card)) {
                ModTools.draw(user, new int[0]);
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }
    }

    public static class Huoji
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.RED));
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isRedCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.FIRE_ATTACK;
        }
    }

    public static class Huilei
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.RED));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.SELF)
        public int wu555(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            LivingEntity killer = null;
            Entity attacker = data.source.getEntity();
            if (attacker instanceof LivingEntity) {
                LivingEntity entity;
                killer = entity = (LivingEntity)attacker;
            } else if (user.getKillCredit() != null) {
                killer = user.getKillCredit();
            }
            if (killer instanceof Player) {
                Player pl = (Player)killer;
                ModTools.voice(user, this, new float[0]);
                CardEvents.cardDiscard((LivingEntity)pl, PlayerEvents.cardsToDrop(pl));
                for (ItemStack stack : pl.getInventory().items) {
                    if (stack.isEmpty()) continue;
                    ModTools.give((LivingEntity)pl, stack.copy(), 400);
                    stack.setCount(0);
                }
            }
            return 0;
        }
    }

    public static class Benxi
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int benxi = skill.getTag();
            tooltip.add((Component)Component.literal((String)("tags: " + benxi)));
            tooltip.add((Component)this.getTip("1", ChatFormatting.RED));
            tooltip.add((Component)this.getTip("2", ChatFormatting.RED));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @Override
        public int getExtraReach(LivingEntity entity, Skill skill) {
            return skill.getTag();
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_USE}, relation=Relation.SELF)
        public int useCard(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            int benxi = skill.getTag();
            if (benxi < 5) {
                skill.setTag(benxi + 1);
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.DIRECT_ATTACKER)
        public int onHit(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            int benxi = skill.getTag();
            if (benxi > 1) {
                skill.setTag(benxi - 2);
                ModTools.draw(user, new int[0]);
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }
    }
}

