/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.command.DabaoSwordCommand;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.event.PlayerEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.item.skillcard.skills.ConvertSkill;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Wei {

    public static class Xingshang
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.NOT_SELF)
        public int playerDie(LivingEntity user, LivingEntity entity, Skill skill, ExData data) {
            Player target;
            if (entity instanceof Player && user.distanceTo((Entity)(target = (Player)entity)) <= 30.0f) {
                ModTools.voice(user, this, new float[0]);
                CardEvents.cardMove((LivingEntity)target, PlayerEvents.cardsToDrop(target), user);
            }
            return 0;
        }
    }

    public static class Yiji
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)"CD: 20s"));
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public void addScreenTip(Skill skill, List<Component> tips) {
            this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 4, 5});
            super.addScreenTip(skill, tips);
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onHurt(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (data.source.is(ModDT.LOSEHP)) {
                return 0;
            }
            if (!user.hasEffect(ModItems.COOLDOWN) && user.getHealth() <= 15.0f) {
                ModTools.draw(user, 2);
                user.addEffect(new MobEffectInstance(ModItems.COOLDOWN, 400, 0, false, false, true));
                skill.setTag(2);
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill, LivingEntity entity) {
            if (entity instanceof Player) {
                Player target = (Player)entity;
                int i = skill.getTag();
                if (i <= 0) {
                    return false;
                }
                skill.setMaxSelect(i);
                ModTools.openInv(user, user, target, (Component)Component.translatable((String)"give_card.title", (Object[])new Object[]{skill.toHoverableText()}), skill.stack, false, false, 2);
                return true;
            }
            return false;
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
            int count = handler.getSelectedCount();
            if (count == 0) {
                return;
            }
            ModTools.voice((LivingEntity)player, this, new float[0]);
            MutableComponent message = Component.translatable((String)"give_card.tip", (Object[])new Object[]{player.getDisplayName(), skill.toHoverableText(), target.getDisplayName(), count});
            target.displayClientMessage((Component)message, false);
            player.displayClientMessage((Component)message, false);
            skill.setTag(skill.getTag() - count);
            CardEvents.cardMove((LivingEntity)player, handler.toExData(), (LivingEntity)target);
        }
    }

    public static class Shensu
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @SkillInfo(trigger={Trigger.MODIFY_DAMAGE}, relation=Relation.DIRECT_ATTACKER)
        public int onHit(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            List<Float> muls = data.muls;
            if (!user.hasEffect(ModItems.COOLDOWN)) {
                float walkSpeed = 4.317f;
                float speed = skill.getNbt().getFloat("speed");
                if (speed > walkSpeed) {
                    float m = (speed - walkSpeed) / walkSpeed / 2.0f;
                    user.addEffect(new MobEffectInstance(ModItems.COOLDOWN, (int)(100.0f * m), 0, false, false, true));
                    if (user instanceof Player) {
                        Player player = (Player)user;
                        player.displayClientMessage((Component)Component.translatable((String)"shensu.info", (Object[])new Object[]{Float.valueOf(speed), Float.valueOf(m)}), true);
                    }
                    ModTools.voice(user, this, new float[0]);
                    muls.add(Float.valueOf(m));
                }
            }
            return 0;
        }

        public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
            Player player;
            Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
            LivingEntity entity = slotContext.entity();
            double d = 0.0;
            if (entity instanceof Player && !(player = (Player)entity).getTags().contains("duanchang")) {
                d = Math.min((double)this.getEmptySlots(player), 20.0) / 40.0;
            }
            modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(id, d, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            return modifiers;
        }

        private int getEmptySlots(Player player) {
            int i = 0;
            for (ItemStack slot : player.getInventory().items) {
                if (!slot.isEmpty()) continue;
                ++i;
            }
            return i;
        }
    }

    public static class Shanzhuan
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)"CD: 8s"));
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.ATTACKER)
        public int onHit(LivingEntity user, LivingEntity entity, Skill skill, ExData data) {
            if (user instanceof Player) {
                Player player = (Player)user;
                if (!user.hasEffect(ModItems.COOLDOWN)) {
                    if (entity instanceof Player) {
                        Player target = (Player)entity;
                        if (ModTools.countAllCards((LivingEntity)target) > 0) {
                            ModTools.openInv(player, target, target, (Component)Component.translatable((String)"dabaosword.discard.title", (Object[])new Object[]{skill.toHoverableText()}), skill.stack, true, false, 1);
                        }
                    } else {
                        ModTools.voice(user, this, new float[0]);
                        Random random = new Random();
                        if ((double)random.nextFloat() < 0.5) {
                            entity.addEffect(new MobEffectInstance(ModItems.BINGLIANG, -1, 1));
                        } else {
                            entity.addEffect(new MobEffectInstance(ModItems.TOO_HAPPY, 100));
                        }
                        user.addEffect(new MobEffectInstance(ModItems.COOLDOWN, 100, 0, false, false, true));
                    }
                }
            }
            return 0;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
            ItemStack selected = handler.getStack(slot);
            ModTools.voice((LivingEntity)player, this, new float[0]);
            if (ModTools.isRedCard.test(selected)) {
                target.addEffect(new MobEffectInstance(ModItems.TOO_HAPPY, 100));
            } else {
                target.addEffect(new MobEffectInstance(ModItems.BINGLIANG, -1, 1));
            }
            MutableComponent message = Component.translatable((String)"dabaosword.discard", (Object[])new Object[]{player.getDisplayName(), target.getDisplayName(), selected.getDisplayName()});
            player.displayClientMessage((Component)message, false);
            target.displayClientMessage((Component)message, false);
            ExData data = ModTools.d().cards(selected, 1, slot < 4);
            CardEvents.cardDiscard((LivingEntity)target, data);
            player.addEffect(new MobEffectInstance(ModItems.COOLDOWN, 240, 0, false, false, true));
            ModTools.closeGUI(player);
        }
    }

    public static class Quanji
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)("tags: " + skill.getTag())));
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @Override
        public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
            if (!world.isClientSide && !user.isShiftKeyDown()) {
                ModTools.voice((LivingEntity)user, "zili", new float[0]);
            }
            return super.use(world, user, hand);
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onHurt(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (data.source.getEntity() instanceof LivingEntity) {
                skill.setTag(skill.getTag() + 1);
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.MODIFY_DAMAGE}, relation=Relation.DIRECT_ATTACKER)
        public int onHit(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            List<Float> adds = data.adds;
            int quan = skill.getTag();
            if (quan > 0) {
                if (quan > 4) {
                    ModTools.draw(target, new int[0]);
                }
                skill.setTag(quan / 2);
                ModTools.voice(user, "paiyi", new float[0]);
                adds.add(Float.valueOf(quan));
            }
            return 0;
        }
    }

    public static class Qingguo
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isBlackCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.SHAN;
        }
    }

    public static class Qice
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 20s" : "CD: 20s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            if (skill.getCD() == 0) {
                if (ModTools.countCards((LivingEntity)user) > 0) {
                    Item[] items = new Item[]{ModItems.BINGLIANG_ITEM, ModItems.TOO_HAPPY_ITEM, ModItems.DISCARD, ModItems.FIRE_ATTACK, ModItems.JIEDAO, ModItems.JUEDOU, ModItems.NANMAN, ModItems.STEAL, ModItems.TAOYUAN, ModItems.TIESUO, ModItems.WANJIAN, ModItems.WUXIE, ModItems.WUGU, ModItems.WUZHONG};
                    List<ItemStack> stacks = Arrays.stream(items).map(ItemStack::new).toList();
                    ModTools.openMenu(user, user, skill.stack, stacks, (Component)Component.translatable((String)"item.dabaosword.qice.screen"));
                    return true;
                }
                user.displayClientMessage((Component)Component.translatable((String)"item.dabaosword.qice.tip").withStyle(ChatFormatting.RED), true);
            } else {
                user.displayClientMessage((Component)Component.translatable((String)"dabaosword.cooldown").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
            ItemStack selected = handler.getStack(slot);
            if (!player.isCreative()) {
                while (ModTools.countCards((LivingEntity)player) > 0) {
                    CardEvents.cardDecrement((LivingEntity)player, ModTools.getCard((LivingEntity)player, ModTools.isCard), 64);
                }
                skill.setCD(20);
            }
            ModTools.give((LivingEntity)player, selected, new int[0]);
            ModTools.voice((LivingEntity)player, this, new float[0]);
            ModTools.closeGUI(player);
        }
    }

    public static class Luoyi
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @Override
        public boolean shouldTickUpdate() {
            return true;
        }

        public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
            Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
            LivingEntity entity = slotContext.entity();
            if (entity != null) {
                int luoyi = entity.getTags().contains("duanchang") ? 0 : this.getEmptyArmorSlot(entity) + 1;
                modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, (double)luoyi, AttributeModifier.Operation.ADD_VALUE));
            }
            return modifiers;
        }

        @Override
        public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
            if (!world.isClientSide && !user.isShiftKeyDown()) {
                ModTools.voice((LivingEntity)user, this, new float[0]);
            }
            return super.use(world, user, hand);
        }

        private int getEmptyArmorSlot(LivingEntity entity) {
            int i = 0;
            for (ItemStack slot : entity.getArmorSlots()) {
                if (!slot.isEmpty()) continue;
                ++i;
            }
            return i;
        }
    }

    public static class Luoshen
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @Override
        public int onDrawPhase(Player player, Skill skill) {
            ModTools.voice((LivingEntity)player, this, new float[0]);
            while (true) {
                ItemStack card = ModTools.newCard();
                player.level().players().forEach(p -> p.displayClientMessage((Component)Component.translatable((String)"item.dabaosword.luoshen.result", (Object[])new Object[]{player.getDisplayName(), card.getDisplayName()}), false));
                if (!ModTools.isBlackCard.test(card)) break;
                ModTools.give((LivingEntity)player, card, new int[0]);
            }
            return 0;
        }
    }

    public static class Jueqing
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.CANCEL_DAMAGE_LOWEST}, relation=Relation.ATTACKER_SELF)
        public int onHit(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Float amount = data.amount;
            target.hurt(ModDT.loseHP((Entity)user), Math.min(Math.max(7.0f, target.getMaxHealth() / 3.0f), amount.floatValue()));
            ModTools.voice(user, this, 1.0f);
            return 1;
        }
    }

    public static class Jianxiong
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)"CD: 15s"));
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onHurt(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            DamageSource source = data.source;
            if (source.getEntity() instanceof Entity && !user.hasEffect(ModItems.COOLDOWN)) {
                ModTools.voice(user, this, new float[0]);
                ModTools.draw(user, new int[0]);
                user.addEffect(new MobEffectInstance(ModItems.COOLDOWN, 300, 0, false, false, true));
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.HURT_BY_CARD}, relation=Relation.SELF)
        public int hurtByCard(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (skill.getCD() == 0) {
                ModTools.voice(user, this, new float[0]);
                skill.setCD(15);
                ModTools.give(user, data.getFirst(new boolean[0]).toStack().copyWithCount(1), new int[0]);
            }
            return 0;
        }
    }

    public static class Gongao
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @Override
        public boolean shouldTickUpdate() {
            return true;
        }

        @Override
        public void tickSkill(Skill skill, LivingEntity entity) {
            if (entity.level().getGameTime() % 600L == 0L && entity instanceof Player) {
                Player player = (Player)entity;
                int extraHP = skill.getTag();
                if (extraHP >= 5 && !player.isCreative() && !player.isSpectator()) {
                    ModTools.draw((LivingEntity)player, 2);
                    skill.setTag(extraHP - 5);
                    ModTools.voice((LivingEntity)player, "weizhong", new float[0]);
                }
            }
        }

        public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
            Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
            modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(id, (double)ModTools.s(stack).getTag(), AttributeModifier.Operation.ADD_VALUE));
            return modifiers;
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.KILLER)
        public int onKill(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            int i;
            int extraHP = skill.getTag();
            int n = target instanceof Player ? 5 : (i = target instanceof Monster ? 1 : 0);
            if (i > 0) {
                extraHP += i;
                user.heal((float)i);
                ModTools.voice(user, this, new float[0]);
            }
            skill.setTag(extraHP);
            return 0;
        }
    }

    public static class Ganglie
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onHurt(LivingEntity user, LivingEntity entity, Skill skill, ExData data) {
            LivingEntity attacker;
            DamageSource source = data.source;
            Float amount = data.amount;
            Entity entity2 = source.getEntity();
            if (entity2 instanceof LivingEntity && user != (attacker = (LivingEntity)entity2)) {
                ModTools.voice(user, this, new float[0]);
                int i = 0;
                while ((float)i < amount.floatValue()) {
                    Random random = new Random();
                    if ((double)random.nextFloat() < 0.5) {
                        user.addTag("sha");
                        float f = (float)(i + 5) < amount.floatValue() ? 5.0f : amount.floatValue() - (float)i;
                        attacker.invulnerableTime = 0;
                        attacker.hurt(user.damageSources().mobAttack(user), f);
                    } else if (attacker instanceof Player) {
                        Player target = (Player)attacker;
                        candidate = ModTools.getItems((LivingEntity)target, ModTools.isCard, true, false, true, true);
                        if (!candidate.isEmpty()) {
                            chosen = candidate.get(new Random().nextInt(candidate.size()));
                            MutableComponent message = Component.translatable((String)"dabaosword.discard", (Object[])new Object[]{user.getDisplayName(), target.getDisplayName(), chosen.getDisplayName()});
                            if (user instanceof Player) {
                                Player player = (Player)user;
                                player.displayClientMessage((Component)message, false);
                            }
                            target.displayClientMessage((Component)message, false);
                            ExData cData = ModTools.d().cards(chosen, 1, ModTools.isEquipped(attacker, s -> s.equals(chosen)));
                            CardEvents.cardDiscard((LivingEntity)target, cData);
                        }
                    } else {
                        candidate = ModTools.getItems(attacker, s -> !s.isEmpty(), true, false, true, false);
                        if (!candidate.isEmpty()) {
                            chosen = candidate.get(new Random().nextInt(candidate.size()));
                            if (ModTools.isCard(chosen)) {
                                ExData cData = ModTools.d().cards(chosen, 1, ModTools.isEquipped(attacker, s -> s.equals(chosen)));
                                CardEvents.cardDiscard(attacker, cData);
                            } else {
                                chosen.shrink(1);
                            }
                        }
                    }
                    i += 5;
                }
            }
            return 0;
        }
    }

    public static class Fangzhu
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onHurt(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            LivingEntity attacker;
            DamageSource source = data.source;
            Float amount = data.amount;
            Entity entity = source.getEntity();
            if (entity instanceof LivingEntity && user != (attacker = (LivingEntity)entity)) {
                int i = attacker instanceof Player ? (int)(20.0f * amount.floatValue() + 60.0f) : 300;
                attacker.addEffect(new MobEffectInstance(ModItems.TURNOVER, i));
                ModTools.voice(user, this, new float[0]);
            }
            return 0;
        }
    }

    public static class Duanliang
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.BLUE));
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isBlackCard.and(ModTools.isArmoury.negate());
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.BINGLIANG_ITEM;
        }
    }

    public static class Daoshu
    extends SkillItem
    implements DabaoSwordCommand.CSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 60s" : "CD: 60s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            if (skill.getCD() == 0 && !user.getTags().contains("seen_skill_tip")) {
                user.displayClientMessage((Component)Component.translatable((String)"active_skill.use.tip", (Object[])new Object[]{skill.toHoverableText(), this.activeSkillText(user, skill)}).withStyle(ChatFormatting.GOLD), false);
                user.addTag("seen_skill_tip");
            }
            return false;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill, LivingEntity target) {
            user.addTag("seen_skill_tip");
            this.triggerSkill((LivingEntity)user, skill, target, 0);
            return false;
        }

        @Override
        public void triggerSkill(LivingEntity entity, Skill skill, LivingEntity target, int value) {
            Player user;
            block9: {
                block8: {
                    if (skill.getCD() > 0 || entity == target) {
                        return;
                    }
                    if (!(entity instanceof Player)) break block8;
                    user = (Player)entity;
                    if (target instanceof Player) break block9;
                }
                return;
            }
            Player tar = (Player)target;
            if (ModTools.countCards((LivingEntity)tar) < 1) {
                user.displayClientMessage((Component)Component.translatable((String)"daoshu.target.no_card").withStyle(ChatFormatting.RED), true);
                return;
            }
            if (value == 0) {
                user.displayClientMessage((Component)Component.translatable((String)"select_a_suit", (Object[])new Object[]{this.daoshuText(user, tar, Suit.Heart), this.daoshuText(user, tar, Suit.Diamond), this.daoshuText(user, tar, Suit.Spade), this.daoshuText(user, tar, Suit.Club)}), false);
                return;
            }
            ModTools.voice((LivingEntity)user, this, new float[0]);
            List<ItemStack> items = ModTools.getItems((LivingEntity)tar, ModTools.isCard, true, false, false, true);
            ItemStack card = items.get(new Random().nextInt(items.size()));
            Card c = ModTools.c(card);
            MutableComponent message = Component.translatable((String)"dabaosword.steal", (Object[])new Object[]{user.getDisplayName(), tar.getDisplayName(), card.getDisplayName()});
            user.displayClientMessage((Component)message, false);
            tar.displayClientMessage((Component)message, false);
            CardEvents.cardMove((LivingEntity)tar, ModTools.d().cards(card, 1, new boolean[0]), (LivingEntity)user);
            if (c.suit.ordinal() + 1 == value) {
                user.addTag("sha");
                tar.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 1));
                tar.hurt(user.damageSources().mobAttack((LivingEntity)user), 6.0f);
            } else {
                skill.setCD(60);
            }
        }

        private MutableComponent daoshuText(Player user, Player target, Suit suit) {
            return suit.suit.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword " + user.getName().getString() + " dabaosword:daoshu " + target.getName().getString() + " " + (suit.ordinal() + 1)))).withStyle(suit.color);
        }
    }

    public static class Chengxiang
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.BLUE));
            tooltip.add((Component)this.getTip("2", ChatFormatting.BLUE));
        }

        @Override
        public void addScreenTip(Skill skill, List<Component> tips) {
            this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 4});
            tips.add((Component)Component.translatable((String)"chengxiang.screen.tip").withStyle(ChatFormatting.LIGHT_PURPLE));
            super.addScreenTip(skill, tips);
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onHurt(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (!(user instanceof Player)) {
                return 0;
            }
            Player pl = (Player)user;
            DamageSource source = data.source;
            Float amount = data.amount;
            if (source.is(ModDT.LOSEHP)) {
                return 0;
            }
            CompoundTag nbt = skill.getNbt();
            float hurt = nbt.getFloat("hurt");
            if ((hurt += amount.floatValue()) >= 7.0f && pl.isAlive()) {
                ModTools.voice((LivingEntity)pl, this, new float[0]);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < 13; ++i) {
                    if (i < 9) {
                        stacks.add(ItemStack.EMPTY);
                        continue;
                    }
                    stacks.add(ModTools.newCard());
                }
                pl.addEffect(new MobEffectInstance(ModItems.INVULNERABLE, 200));
                ModTools.openMenu(pl, pl, skill.stack, stacks, skill.toHoverableText());
            }
            while (hurt >= 7.0f) {
                hurt -= 7.0f;
            }
            nbt.putFloat("hurt", hurt);
            skill.setNbt(nbt);
            return 0;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
            int points = 0;
            for (ItemStack stack : handler.getSelected()) {
                points += ModTools.c((ItemStack)stack).rank.ordinal() + 1;
            }
            points += ModTools.c((ItemStack)handler.getStack((int)slot)).rank.ordinal() + 1;
            if (action == ClickType.PICKUP) {
                if (points <= 13 && button == 0) {
                    handler.addClick(slot, new int[0]);
                }
                if (button == 1) {
                    handler.dropClick(slot, new int[0]);
                }
            }
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
            if (handler.getSelectedCount() > 0) {
                handler.toExData().forEachCard(3, (c, i) -> ModTools.give((LivingEntity)player, c.toStack().copyWithCount(i.intValue()), new int[0]));
            } else {
                ModTools.give((LivingEntity)player, handler.getStack(9), new int[0]);
            }
            player.removeEffect(ModItems.INVULNERABLE);
        }
    }
}

