/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Relation;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillInfo;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.command.DabaoSwordCommand;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.item.skillcard.skills.ConvertSkill;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Wu {

    public static class Zhijian
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip("1", ChatFormatting.GREEN));
            tooltip.add((Component)this.getTip("2", ChatFormatting.GREEN));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill, LivingEntity target) {
            ItemStack itemStack = user.getMainHandItem();
            if (ModTools.isEquipment.test(itemStack)) {
                ExData data = ModTools.d().cards(itemStack, 1, new boolean[0]);
                CardEvents.cardToEquip((LivingEntity)user, data, target);
                ModTools.voice((LivingEntity)user, this, new float[0]);
                ModTools.draw((LivingEntity)user, new int[0]);
                return true;
            }
            user.displayClientMessage((Component)Component.translatable((String)"zhijian.fail").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public static class Zhiheng
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 30s" : "CD: 30s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip("1", ChatFormatting.GREEN));
            tooltip.add((Component)this.getTip("2", ChatFormatting.GREEN));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public void addScreenTip(Skill skill, List<Component> tips) {
            this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 3, 4});
            super.addScreenTip(skill, tips);
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            if (ModTools.countAllCards((LivingEntity)user) == 0) {
                return false;
            }
            int cd = skill.getCD();
            if (cd <= 0) {
                ModTools.openInv(user, user, user, (Component)Component.translatable((String)"zhiheng.title"), skill.stack, true, false, 2);
                return true;
            }
            user.displayClientMessage((Component)Component.translatable((String)"dabaosword.cooldown").withStyle(ChatFormatting.RED), true);
            return false;
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, Player player, Skill skill, Player target) {
            int num = handler.getSelectedCount();
            if (num == 0) {
                return;
            }
            ModTools.voice((LivingEntity)player, this, new float[0]);
            ExData data = handler.toExData();
            int count = ModTools.countCards((LivingEntity)player);
            if (count == 0 || count == data.cards_from_inv.size()) {
                // empty if block
            }
            CardEvents.cardDiscard((LivingEntity)player, data);
            ModTools.draw((LivingEntity)player, ++num);
            skill.setCD(30);
        }
    }

    public static class Yingzi
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public int onDrawPhase(Player player, Skill skill) {
            ModTools.voice((LivingEntity)player, this, new float[0]);
            return 1;
        }
    }

    public static class Xiaoji
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_DISCARD, Trigger.LOSE_CARD_MOVE}, relation=Relation.SELF)
        public int loseEquip(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Map<Card, Integer> equips = data.cards_from_equ;
            if (user.isAlive() && !equips.isEmpty()) {
                ModTools.voice(user, this, new float[0]);
                ModTools.draw(user, 2 * equips.size());
            }
            return 0;
        }
    }

    public static class Shixin
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.CANCEL_DAMAGE_HIGH}, relation=Relation.SELF)
        public int fanghuo(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (data.source.is(DamageTypeTags.IS_FIRE)) {
                if (skill.getCD() == 0) {
                    ModTools.voice(user, this, new float[0]);
                    skill.setCD(10);
                }
                return 1;
            }
            return 0;
        }
    }

    public static class Qixi
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public boolean chooseEquipment() {
            return true;
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isBlackCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.DISCARD;
        }
    }

    public static class Pojun
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)"CD: 10s"));
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public void preAttack(Player player, LivingEntity target, Skill skill) {
            if (!player.hasEffect(ModItems.COOLDOWN)) {
                for (ItemStack armor : target.getArmorSlots()) {
                    if (armor.isEmpty()) continue;
                    if (target instanceof Player) {
                        Player pl = (Player)target;
                        ModTools.give((LivingEntity)pl, armor.copy(), 100);
                        armor.setCount(0);
                        continue;
                    }
                    target.spawnAtLocation(armor.copy());
                    armor.setCount(0);
                }
                ModTools.voice((LivingEntity)player, this, new float[0]);
                int i = target instanceof Player ? 200 : 40;
                player.addEffect(new MobEffectInstance(ModItems.COOLDOWN, i, 0, false, false, true));
            }
        }
    }

    public static class Liuli
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.DROP_TARGET}, relation=Relation.NOT_SELF)
        public int beiSha(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            LivingEntity near;
            List<LivingEntity> targets = data.targets;
            Card card = data.getFirst(new boolean[0]);
            if (ModTools.isSha.test(card.toStack()) && targets.contains(user) && ModTools.hasCard(user, ModTools.isCard) && (near = ModTools.getClosestEntity((Entity)user, LivingEntity.class, 50.0, entity -> entity != target)) != null) {
                targets.add(near);
                data.removeTarget(user);
                ModTools.voice(user, this, new float[0]);
                ExData d = ModTools.d().cards(ModTools.getCard(user, ModTools.isCard), 1, new boolean[0]);
                CardEvents.cardDiscard(user, d);
            }
            return 0;
        }
    }

    public static class Lianying
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public void tickSkill(Skill skill, LivingEntity entity) {
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                int cd = skill.getCD();
                if (world.getGameTime() % 20L == 0L && cd == 1) {
                    ModTools.draw(entity, new int[0]);
                    ModTools.voice(entity, this, new float[0]);
                }
            }
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_USE, Trigger.LOSE_CARD_DISCARD, Trigger.LOSE_CARD_MOVE}, relation=Relation.SELF)
        public int loseCard(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            if (user.isDeadOrDying()) {
                return 0;
            }
            Map<Card, Integer> lostCards = data.cards_from_inv;
            if (!lostCards.isEmpty() && ModTools.countCards(user) == 0) {
                skill.setCD(5);
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.SELF)
        public int die(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            skill.setCD(0);
            return 0;
        }
    }

    public static class Kurou
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            if ((double)(user.getHealth() + (float)(5 * ModTools.countCard((LivingEntity)user, ModTools.canSaveDying))) > 4.99) {
                ModTools.draw((LivingEntity)user, 2);
                if (!user.isCreative()) {
                    user.invulnerableTime = 0;
                    user.hurt(ModDT.loseHP((Entity)user), 4.99f);
                }
                ModTools.voice((LivingEntity)user, this, new float[0]);
                return true;
            }
            user.displayClientMessage((Component)Component.translatable((String)"item.dabaosword.kurou.tip").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public static class Guose
    extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public boolean chooseEquipment() {
            return true;
        }

        @Override
        public Predicate<ItemStack> getConvertFilter() {
            return ModTools.isDiamondCard;
        }

        @Override
        public CardItem convert(ItemStack stack) {
            return ModItems.TOO_HAPPY_ITEM;
        }
    }

    public static class Gongxin
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 30s" : "CD: 30s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill, LivingEntity entity) {
            Player target;
            if (entity instanceof Player && ModTools.countCards((LivingEntity)(target = (Player)entity)) > 0) {
                int cd = skill.getCD();
                if (cd > 0) {
                    user.displayClientMessage((Component)Component.translatable((String)"dabaosword.cooldown").withStyle(ChatFormatting.RED), true);
                } else {
                    ModTools.voice((LivingEntity)user, this, new float[0]);
                    ModTools.openInv(user, target, target, (Component)Component.translatable((String)"gongxin.title"), skill.stack, false, false, 2);
                    skill.setCD(30);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, Player player, Skill skill, Player target, int slot, int button, ClickType action) {
            ItemStack selected = handler.getStack(slot);
            target.displayClientMessage((Component)Component.translatable((String)"dabaosword.discard", (Object[])new Object[]{player.getDisplayName(), target.getDisplayName(), selected.getDisplayName()}), false);
            ExData data = ModTools.d().cards(selected, 1, new boolean[0]);
            CardEvents.cardDiscard((LivingEntity)target, data);
            ModTools.closeGUI(player);
        }
    }

    public static class Fenyin
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            tooltip.add((Component)this.getTip(ChatFormatting.GREEN));
        }

        @SkillInfo(trigger={Trigger.LOSE_CARD_USE}, relation=Relation.SELF)
        public int useCard(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            int current;
            int last;
            ItemStack card = data.getFirst(new boolean[0]).toStack();
            CompoundTag nbt = skill.getNbt();
            int n = last = nbt.contains("fenyin") ? nbt.getInt("fenyin") : 0;
            int n2 = ModTools.isRedCard.test(card) ? 1 : (current = ModTools.isBlackCard.test(card) ? 2 : 0);
            if (last != 0 && current != 0 && current != last) {
                ModTools.draw(user, new int[0]);
                ModTools.voice(user, this, new float[0]);
            }
            nbt.putInt("fenyin", current);
            skill.setNbt(nbt);
            return 0;
        }
    }

    public static class Fanjian
    extends SkillItem
    implements DabaoSwordCommand.CSkill {
        private static final String FJ = "fanjian";

        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            int cd = skill.getCD();
            tooltip.add((Component)Component.literal((String)(cd == 0 ? "CD: 30s" : "CD: 30s   left: " + cd + "s")));
            tooltip.add((Component)this.getTip("1", ChatFormatting.GREEN));
            tooltip.add((Component)this.getTip("2", ChatFormatting.GREEN));
        }

        @Override
        public boolean isActiveSkill() {
            return true;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill) {
            if (skill.getCD() == 0 && ModTools.countCards((LivingEntity)user) > 0 && !user.getTags().contains("seen_skill_tip")) {
                user.displayClientMessage((Component)Component.translatable((String)"active_skill.use.tip", (Object[])new Object[]{skill.toHoverableText(), this.activeSkillText(user, skill)}).withStyle(ChatFormatting.GOLD), false);
                user.addTag("seen_skill_tip");
            }
            return false;
        }

        @Override
        public boolean activeSkill(Player user, Skill skill, LivingEntity target) {
            if (user == target) {
                return false;
            }
            if (skill.getCD() > 0) {
                return false;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                if (ModTools.countCards((LivingEntity)user) > 0) {
                    ModTools.voice((LivingEntity)user, this, new float[0]);
                    skill.setCD(30);
                    ModTools.addTag((Entity)player, FJ, user.getName().getString());
                    player.displayClientMessage((Component)Component.translatable((String)"select_a_suit", (Object[])new Object[]{this.fanjianText(user, player, Suit.Heart), this.fanjianText(user, player, Suit.Diamond), this.fanjianText(user, player, Suit.Spade), this.fanjianText(user, player, Suit.Club)}), false);
                    player.displayClientMessage((Component)Component.translatable((String)"fanjian.time.tip").withStyle(ChatFormatting.BOLD), false);
                    return true;
                }
            }
            return false;
        }

        private MutableComponent fanjianText(Player user, Player player, Suit suit) {
            return suit.suit.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/dabaosword " + user.getName().getString() + " dabaosword:fanjian " + player.getName().getString() + " " + (suit.ordinal() + 1)))).withStyle(suit.color);
        }

        @Override
        public void triggerSkill(LivingEntity entity, Skill skill, LivingEntity target, int value) {
            if (entity instanceof Player) {
                Player user = (Player)entity;
                if (ModTools.countCards((LivingEntity)user) == 0) {
                    skill.setCD(0);
                    return;
                }
                if (value == 0) {
                    this.activeSkill(user, skill, target);
                    return;
                }
                if (skill.getCD() < 21) {
                    return;
                }
                ModTools.voice((LivingEntity)user, this, new float[0]);
                List<ItemStack> items = ModTools.getItems((LivingEntity)user, ModTools.isCard, true, false, false, true);
                ItemStack card = items.get(new Random().nextInt(items.size()));
                Card c = ModTools.c(card);
                MutableComponent message = Component.translatable((String)"dabaosword.steal", (Object[])new Object[]{target.getDisplayName(), user.getDisplayName(), card.getDisplayName()});
                user.displayClientMessage((Component)message, false);
                if (target instanceof Player) {
                    Player tp = (Player)target;
                    tp.displayClientMessage((Component)message, false);
                }
                CardEvents.cardMove((LivingEntity)user, ModTools.d().cards(card, 1, new boolean[0]), target);
                if (c.suit.ordinal() + 1 != value) {
                    user.addTag("sha");
                    target.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 1));
                    target.hurt(ModTools.getDamageSource((Entity)user, (ResourceKey<DamageType>)DamageTypes.MAGIC), 6.0f);
                }
                skill.setCD(20);
            }
        }

        @Override
        public void tickSkill(Skill skill, LivingEntity entity) {
            int cd;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).level().getGameTime() % 10L == 0L && ((cd = skill.getCD()) == 21 || cd == 0)) {
                String tag = "fanjian_" + player.getName().getString();
                Predicate<LivingEntity> p = e -> ModTools.hasTag((Entity)e, tag);
                LivingEntity target = ModTools.getClosestEntity((Entity)player, LivingEntity.class, 20.0, p);
                if (target == null) {
                    target = player.level().players().stream().filter(p).findFirst().orElse(null);
                }
                if (target == null) {
                    return;
                }
                if (cd == 21) {
                    this.triggerSkill((LivingEntity)player, skill, target, new Random().nextInt(4) + 1);
                }
                ModTools.removeTag((Entity)target, tag);
            }
        }
    }

    public static class Buqu
    extends SkillItem {
        @Override
        public void addTip(Skill skill, List<Component> tooltip) {
            String c = skill.getNbt().getString("Chuang");
            if (!c.isEmpty()) {
                tooltip.add((Component)Component.literal((String)("\u521b\uff1a" + c)));
            }
            tooltip.add((Component)this.getTip("1", ChatFormatting.GREEN));
            tooltip.add((Component)this.getTip("2", ChatFormatting.GREEN));
        }

        @Override
        public boolean lockOn() {
            return true;
        }

        @SkillInfo(trigger={Trigger.ON_HURT}, relation=Relation.SELF)
        public int onDying(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            Player player;
            if (user instanceof Player && (player = (Player)user).isDeadOrDying()) {
                CompoundTag nbt = skill.getNbt();
                String chuang = nbt.getString("Chuang");
                if (chuang.length() > 36) {
                    return 0;
                }
                Card card = ModTools.c(ModTools.newCard());
                player.level().players().forEach(p -> p.displayClientMessage((Component)Component.translatable((String)"buqu.tip1", (Object[])new Object[]{player.getDisplayName(), skill.toHoverableText(), card.toStack().getDisplayName(), card.rank.rank}), false));
                if (chuang.isEmpty()) {
                    nbt.putString("Chuang", card.rank.rank);
                    ModTools.voice((LivingEntity)player, this, new float[0]);
                    player.setHealth(1.0f);
                } else if (!chuang.contains(card.rank.rank)) {
                    nbt.putString("Chuang", chuang + ", " + card.rank.rank);
                    ModTools.voice((LivingEntity)player, this, new float[0]);
                    player.setHealth(1.0f);
                } else {
                    ModTools.voice((LivingEntity)player, "zhoutai", new float[0]);
                    if (chuang.split(", ").length < 3) {
                        player.displayClientMessage((Component)Component.translatable((String)"buqu.tip2").withStyle(ChatFormatting.RED), false);
                    }
                }
                skill.setNbt(nbt);
            }
            return 0;
        }

        @SkillInfo(trigger={Trigger.ON_DEATH}, relation=Relation.SELF)
        public int die(LivingEntity user, LivingEntity target, Skill skill, ExData data) {
            CompoundTag nbt = skill.getNbt();
            String chuang = nbt.getString("Chuang");
            if (chuang.length() > 6) {
                chuang = chuang.substring(6);
                nbt.putString("Chuang", chuang);
            } else {
                nbt.remove("Chuang");
            }
            skill.setNbt(nbt);
            return 0;
        }
    }
}

