/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.tool;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ArrowRainItem
extends Item {
    public ArrowRainItem() {
        super(new Item.Properties().durability(50).rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.wanjian.tooltip"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && hand == InteractionHand.MAIN_HAND) {
            ArrowRainItem.arrowRain((LivingEntity)player, 5.0f, 5);
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static void arrowRain(LivingEntity entity, float speed, int count) {
        ServerLevel world = (ServerLevel)entity.level();
        for (int i = 0; i < count; ++i) {
            int j = i % 2 == 0 ? -5 * i / 2 : 5 * (i + 1) / 2;
            ArrowRainItem.summonArrow(entity, j, speed);
        }
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
    }

    private static void summonArrow(LivingEntity entity, int angle, float speed) {
        ItemStack stack = new ItemStack((ItemLike)Items.ARROW);
        ServerLevel world = (ServerLevel)entity.level();
        Arrow arrow = new Arrow((Level)world, entity, stack, null);
        arrow.addTag("a");
        arrow.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot() + (float)angle, 0.0f, speed, 1.0f);
        arrow.setCritArrow(true);
        world.addFreshEntity((Entity)arrow);
    }

    public static void arrowAround(LivingEntity entity, float speed, int count, double radius, double height) {
        ServerLevel world = (ServerLevel)entity.level();
        for (int i = 0; i < count; ++i) {
            float angle = (float)((double)i * (360.0 / (double)count));
            double radians = Math.toRadians(angle);
            double xOffset = Math.cos(radians) * radius;
            double zOffset = Math.sin(radians) * radius;
            double x = entity.getX() + xOffset;
            double z = entity.getZ() + zOffset;
            double y = entity.getY() + height;
            ArrowRainItem.summonArrowToEntity(entity, x, y, z, speed);
        }
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
    }

    private static void summonArrowToEntity(LivingEntity target, double x, double y, double z, float speed) {
        ServerLevel world = (ServerLevel)target.level();
        Arrow arrow = new Arrow((Level)world, x, y, z, new ItemStack((ItemLike)Items.ARROW), null);
        arrow.addTag("cosmetic");
        double dx = target.getX() - x;
        double dy = target.getY() + (double)target.getEyeHeight(target.getPose()) - y;
        double dz = target.getZ() - z;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        arrow.shoot(dx / distance * (double)speed, dy / distance * (double)speed, dz / distance * (double)speed, speed, 1.0f);
        arrow.setCritArrow(true);
        world.addFreshEntity((Entity)arrow);
    }

    public static void tridentStorm(LivingEntity entity, float speed, int count, double radius, double height) {
        ServerLevel world = (ServerLevel)entity.level();
        for (int i = 0; i < count; ++i) {
            float angle = (float)((double)i * (360.0 / (double)count));
            double radians = Math.toRadians(angle);
            double xOffset = Math.cos(radians) * radius;
            double zOffset = Math.sin(radians) * radius;
            double x = entity.getX() + xOffset;
            double z = entity.getZ() + zOffset;
            double y = entity.getY() + height;
            ArrowRainItem.summonTridentToEntity(entity, x, y, z, speed);
        }
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
    }

    private static void summonTridentToEntity(LivingEntity target, double x, double y, double z, float speed) {
        ServerLevel world = (ServerLevel)target.level();
        ThrownTrident trident = new ThrownTrident((Level)world, target, new ItemStack((ItemLike)Items.TRIDENT));
        trident.addTag("a");
        double dx = target.getX() - x;
        double dy = target.getY() + (double)target.getEyeHeight(target.getPose()) - y;
        double dz = target.getZ() - z;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        world.addFreshEntity((Entity)trident);
        trident.shoot(dx / distance * (double)speed, dy / distance * (double)speed, dz / distance * (double)speed, speed, 1.0f);
        trident.setCritArrow(true);
        trident.moveTo(x, y, z);
    }
}

